/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticloadbalancingv2.transform;

import java.util.List;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringUtils;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.Certificate;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.RemoveListenerCertificatesRequest;

public class RemoveListenerCertificatesRequestMarshaller
implements Marshaller<Request<RemoveListenerCertificatesRequest>, RemoveListenerCertificatesRequest> {
    public Request<RemoveListenerCertificatesRequest> marshall(RemoveListenerCertificatesRequest removeListenerCertificatesRequest) {
        List<Certificate> certificatesList;
        if (removeListenerCertificatesRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((Object)removeListenerCertificatesRequest, "ElasticLoadBalancingv2Client");
        request.addParameter("Action", "RemoveListenerCertificates");
        request.addParameter("Version", "2015-12-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (removeListenerCertificatesRequest.listenerArn() != null) {
            request.addParameter("ListenerArn", StringUtils.fromString((String)removeListenerCertificatesRequest.listenerArn()));
        }
        if ((certificatesList = removeListenerCertificatesRequest.certificates()) != null) {
            if (!certificatesList.isEmpty()) {
                int certificatesListIndex = 1;
                for (Certificate certificatesListValue : certificatesList) {
                    if (certificatesListValue.certificateArn() != null) {
                        request.addParameter("Certificates.member." + certificatesListIndex + ".CertificateArn", StringUtils.fromString((String)certificatesListValue.certificateArn()));
                    }
                    if (certificatesListValue.isDefault() != null) {
                        request.addParameter("Certificates.member." + certificatesListIndex + ".IsDefault", StringUtils.fromBoolean((Boolean)certificatesListValue.isDefault()));
                    }
                    ++certificatesListIndex;
                }
            } else {
                request.addParameter("Certificates", "");
            }
        }
        return request;
    }
}

