/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticloadbalancingv2.transform;

import java.util.List;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringUtils;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeSSLPoliciesRequest;

public class DescribeSSLPoliciesRequestMarshaller
implements Marshaller<Request<DescribeSSLPoliciesRequest>, DescribeSSLPoliciesRequest> {
    public Request<DescribeSSLPoliciesRequest> marshall(DescribeSSLPoliciesRequest describeSSLPoliciesRequest) {
        if (describeSSLPoliciesRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((Object)describeSSLPoliciesRequest, "ElasticLoadBalancingv2Client");
        request.addParameter("Action", "DescribeSSLPolicies");
        request.addParameter("Version", "2015-12-01");
        request.setHttpMethod(HttpMethodName.POST);
        List<String> namesList = describeSSLPoliciesRequest.names();
        if (namesList != null) {
            if (!namesList.isEmpty()) {
                int namesListIndex = 1;
                for (String namesListValue : namesList) {
                    if (namesListValue != null) {
                        request.addParameter("Names.member." + namesListIndex, StringUtils.fromString((String)namesListValue));
                    }
                    ++namesListIndex;
                }
            } else {
                request.addParameter("Names", "");
            }
        }
        if (describeSSLPoliciesRequest.marker() != null) {
            request.addParameter("Marker", StringUtils.fromString((String)describeSSLPoliciesRequest.marker()));
        }
        if (describeSSLPoliciesRequest.pageSize() != null) {
            request.addParameter("PageSize", StringUtils.fromInteger((Integer)describeSSLPoliciesRequest.pageSize()));
        }
        return request;
    }
}

