/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticloadbalancingv2.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class LoadBalancerAddress
implements ToCopyableBuilder<Builder, LoadBalancerAddress> {
    private final String ipAddress;
    private final String allocationId;

    private LoadBalancerAddress(BuilderImpl builder) {
        this.ipAddress = builder.ipAddress;
        this.allocationId = builder.allocationId;
    }

    public String ipAddress() {
        return this.ipAddress;
    }

    public String allocationId() {
        return this.allocationId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.ipAddress());
        hashCode = 31 * hashCode + Objects.hashCode(this.allocationId());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LoadBalancerAddress)) {
            return false;
        }
        LoadBalancerAddress other = (LoadBalancerAddress)obj;
        return Objects.equals(this.ipAddress(), other.ipAddress()) && Objects.equals(this.allocationId(), other.allocationId());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.ipAddress() != null) {
            sb.append("IpAddress: ").append(this.ipAddress()).append(",");
        }
        if (this.allocationId() != null) {
            sb.append("AllocationId: ").append(this.allocationId()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "IpAddress": {
                return Optional.of(clazz.cast(this.ipAddress()));
            }
            case "AllocationId": {
                return Optional.of(clazz.cast(this.allocationId()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String ipAddress;
        private String allocationId;

        private BuilderImpl() {
        }

        private BuilderImpl(LoadBalancerAddress model) {
            this.ipAddress(model.ipAddress);
            this.allocationId(model.allocationId);
        }

        public final String getIpAddress() {
            return this.ipAddress;
        }

        @Override
        public final Builder ipAddress(String ipAddress) {
            this.ipAddress = ipAddress;
            return this;
        }

        public final void setIpAddress(String ipAddress) {
            this.ipAddress = ipAddress;
        }

        public final String getAllocationId() {
            return this.allocationId;
        }

        @Override
        public final Builder allocationId(String allocationId) {
            this.allocationId = allocationId;
            return this;
        }

        public final void setAllocationId(String allocationId) {
            this.allocationId = allocationId;
        }

        public LoadBalancerAddress build() {
            return new LoadBalancerAddress(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, LoadBalancerAddress> {
        public Builder ipAddress(String var1);

        public Builder allocationId(String var1);
    }
}

