/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticloadbalancingv2.transform;

import javax.xml.stream.events.XMLEvent;
import software.amazon.awssdk.core.runtime.transform.SimpleTypeStaxUnmarshallers;
import software.amazon.awssdk.core.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.TargetHealthDescription;
import software.amazon.awssdk.services.elasticloadbalancingv2.transform.TargetDescriptionUnmarshaller;
import software.amazon.awssdk.services.elasticloadbalancingv2.transform.TargetHealthUnmarshaller;

public class TargetHealthDescriptionUnmarshaller
implements Unmarshaller<TargetHealthDescription, StaxUnmarshallerContext> {
    private static final TargetHealthDescriptionUnmarshaller INSTANCE = new TargetHealthDescriptionUnmarshaller();

    public TargetHealthDescription unmarshall(StaxUnmarshallerContext context) throws Exception {
        XMLEvent xmlEvent;
        TargetHealthDescription.Builder targetHealthDescription = TargetHealthDescription.builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (!(xmlEvent = context.nextEvent()).isEndDocument()) {
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("Target", targetDepth)) {
                    targetHealthDescription.target(TargetDescriptionUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("HealthCheckPort", targetDepth)) {
                    targetHealthDescription.healthCheckPort(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("TargetHealth", targetDepth)) continue;
                targetHealthDescription.targetHealth(TargetHealthUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (!xmlEvent.isEndElement() || context.getCurrentDepth() >= originalDepth) continue;
            break;
        }
        return (TargetHealthDescription)targetHealthDescription.build();
    }

    public static TargetHealthDescriptionUnmarshaller getInstance() {
        return INSTANCE;
    }
}

