/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticloadbalancingv2.transform;

import java.util.List;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringUtils;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.SetSecurityGroupsRequest;

public class SetSecurityGroupsRequestMarshaller
implements Marshaller<Request<SetSecurityGroupsRequest>, SetSecurityGroupsRequest> {
    public Request<SetSecurityGroupsRequest> marshall(SetSecurityGroupsRequest setSecurityGroupsRequest) {
        List<String> securityGroupsList;
        if (setSecurityGroupsRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)setSecurityGroupsRequest, "ElasticLoadBalancingv2Client");
        request.addParameter("Action", "SetSecurityGroups");
        request.addParameter("Version", "2015-12-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (setSecurityGroupsRequest.loadBalancerArn() != null) {
            request.addParameter("LoadBalancerArn", StringUtils.fromString((String)setSecurityGroupsRequest.loadBalancerArn()));
        }
        if ((securityGroupsList = setSecurityGroupsRequest.securityGroups()) != null) {
            if (!securityGroupsList.isEmpty()) {
                int securityGroupsListIndex = 1;
                for (String securityGroupsListValue : securityGroupsList) {
                    if (securityGroupsListValue != null) {
                        request.addParameter("SecurityGroups.member." + securityGroupsListIndex, StringUtils.fromString((String)securityGroupsListValue));
                    }
                    ++securityGroupsListIndex;
                }
            } else {
                request.addParameter("SecurityGroups", "");
            }
        }
        return request;
    }
}

