/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticloadbalancingv2.transform;

import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringUtils;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeListenerCertificatesRequest;

public class DescribeListenerCertificatesRequestMarshaller
implements Marshaller<Request<DescribeListenerCertificatesRequest>, DescribeListenerCertificatesRequest> {
    public Request<DescribeListenerCertificatesRequest> marshall(DescribeListenerCertificatesRequest describeListenerCertificatesRequest) {
        if (describeListenerCertificatesRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)describeListenerCertificatesRequest, "ElasticLoadBalancingv2Client");
        request.addParameter("Action", "DescribeListenerCertificates");
        request.addParameter("Version", "2015-12-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (describeListenerCertificatesRequest.listenerArn() != null) {
            request.addParameter("ListenerArn", StringUtils.fromString((String)describeListenerCertificatesRequest.listenerArn()));
        }
        if (describeListenerCertificatesRequest.marker() != null) {
            request.addParameter("Marker", StringUtils.fromString((String)describeListenerCertificatesRequest.marker()));
        }
        if (describeListenerCertificatesRequest.pageSize() != null) {
            request.addParameter("PageSize", StringUtils.fromInteger((Integer)describeListenerCertificatesRequest.pageSize()));
        }
        return request;
    }
}

