/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticloadbalancingv2.transform;

import java.util.List;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringUtils;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.Action;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.CreateRuleRequest;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.RuleCondition;

public class CreateRuleRequestMarshaller
implements Marshaller<Request<CreateRuleRequest>, CreateRuleRequest> {
    public Request<CreateRuleRequest> marshall(CreateRuleRequest createRuleRequest) {
        List<Action> actionsList;
        List<RuleCondition> conditionsList;
        if (createRuleRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)createRuleRequest, "ElasticLoadBalancingv2Client");
        request.addParameter("Action", "CreateRule");
        request.addParameter("Version", "2015-12-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (createRuleRequest.listenerArn() != null) {
            request.addParameter("ListenerArn", StringUtils.fromString((String)createRuleRequest.listenerArn()));
        }
        if ((conditionsList = createRuleRequest.conditions()) != null) {
            if (!conditionsList.isEmpty()) {
                int conditionsListIndex = 1;
                for (RuleCondition conditionsListValue : conditionsList) {
                    List<String> valuesList;
                    if (conditionsListValue.field() != null) {
                        request.addParameter("Conditions.member." + conditionsListIndex + ".Field", StringUtils.fromString((String)conditionsListValue.field()));
                    }
                    if ((valuesList = conditionsListValue.values()) != null) {
                        if (!valuesList.isEmpty()) {
                            int valuesListIndex = 1;
                            for (String valuesListValue : valuesList) {
                                if (valuesListValue != null) {
                                    request.addParameter("Conditions.member." + conditionsListIndex + ".Values.member." + valuesListIndex, StringUtils.fromString((String)valuesListValue));
                                }
                                ++valuesListIndex;
                            }
                        } else {
                            request.addParameter("Conditions.member." + conditionsListIndex + ".Values", "");
                        }
                    }
                    ++conditionsListIndex;
                }
            } else {
                request.addParameter("Conditions", "");
            }
        }
        if (createRuleRequest.priority() != null) {
            request.addParameter("Priority", StringUtils.fromInteger((Integer)createRuleRequest.priority()));
        }
        if ((actionsList = createRuleRequest.actions()) != null) {
            if (!actionsList.isEmpty()) {
                int actionsListIndex = 1;
                for (Action actionsListValue : actionsList) {
                    if (actionsListValue.typeString() != null) {
                        request.addParameter("Actions.member." + actionsListIndex + ".Type", StringUtils.fromString((String)actionsListValue.typeString()));
                    }
                    if (actionsListValue.targetGroupArn() != null) {
                        request.addParameter("Actions.member." + actionsListIndex + ".TargetGroupArn", StringUtils.fromString((String)actionsListValue.targetGroupArn()));
                    }
                    ++actionsListIndex;
                }
            } else {
                request.addParameter("Actions", "");
            }
        }
        return request;
    }
}

