/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticloadbalancingv2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.LoadBalancerAttribute;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.LoadBalancerAttributesCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ModifyLoadBalancerAttributesRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, ModifyLoadBalancerAttributesRequest> {
    private final String loadBalancerArn;
    private final List<LoadBalancerAttribute> attributes;

    private ModifyLoadBalancerAttributesRequest(BuilderImpl builder) {
        this.loadBalancerArn = builder.loadBalancerArn;
        this.attributes = builder.attributes;
    }

    public String loadBalancerArn() {
        return this.loadBalancerArn;
    }

    public List<LoadBalancerAttribute> attributes() {
        return this.attributes;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.loadBalancerArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.attributes());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModifyLoadBalancerAttributesRequest)) {
            return false;
        }
        ModifyLoadBalancerAttributesRequest other = (ModifyLoadBalancerAttributesRequest)((Object)obj);
        return Objects.equals(this.loadBalancerArn(), other.loadBalancerArn()) && Objects.equals(this.attributes(), other.attributes());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.loadBalancerArn() != null) {
            sb.append("LoadBalancerArn: ").append(this.loadBalancerArn()).append(",");
        }
        if (this.attributes() != null) {
            sb.append("Attributes: ").append(this.attributes()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "LoadBalancerArn": {
                return Optional.of(clazz.cast(this.loadBalancerArn()));
            }
            case "Attributes": {
                return Optional.of(clazz.cast(this.attributes()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String loadBalancerArn;
        private List<LoadBalancerAttribute> attributes;

        private BuilderImpl() {
        }

        private BuilderImpl(ModifyLoadBalancerAttributesRequest model) {
            this.loadBalancerArn(model.loadBalancerArn);
            this.attributes(model.attributes);
        }

        public final String getLoadBalancerArn() {
            return this.loadBalancerArn;
        }

        @Override
        public final Builder loadBalancerArn(String loadBalancerArn) {
            this.loadBalancerArn = loadBalancerArn;
            return this;
        }

        public final void setLoadBalancerArn(String loadBalancerArn) {
            this.loadBalancerArn = loadBalancerArn;
        }

        public final Collection<LoadBalancerAttribute.Builder> getAttributes() {
            return this.attributes != null ? (Collection)this.attributes.stream().map(LoadBalancerAttribute::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder attributes(Collection<LoadBalancerAttribute> attributes) {
            this.attributes = LoadBalancerAttributesCopier.copy(attributes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attributes(LoadBalancerAttribute ... attributes) {
            this.attributes(Arrays.asList(attributes));
            return this;
        }

        public final void setAttributes(Collection<LoadBalancerAttribute.BuilderImpl> attributes) {
            this.attributes = LoadBalancerAttributesCopier.copyFromBuilder(attributes);
        }

        public ModifyLoadBalancerAttributesRequest build() {
            return new ModifyLoadBalancerAttributesRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ModifyLoadBalancerAttributesRequest> {
        public Builder loadBalancerArn(String var1);

        public Builder attributes(Collection<LoadBalancerAttribute> var1);

        public Builder attributes(LoadBalancerAttribute ... var1);
    }
}

