/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticloadbalancingv2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.core.AmazonWebServiceResult;
import software.amazon.awssdk.core.ResponseMetadata;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.TargetGroup;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.TargetGroupsCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class CreateTargetGroupResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, CreateTargetGroupResponse> {
    private final List<TargetGroup> targetGroups;

    private CreateTargetGroupResponse(BuilderImpl builder) {
        this.targetGroups = builder.targetGroups;
    }

    public List<TargetGroup> targetGroups() {
        return this.targetGroups;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.targetGroups());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateTargetGroupResponse)) {
            return false;
        }
        CreateTargetGroupResponse other = (CreateTargetGroupResponse)((Object)obj);
        return Objects.equals(this.targetGroups(), other.targetGroups());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.targetGroups() != null) {
            sb.append("TargetGroups: ").append(this.targetGroups()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TargetGroups": {
                return Optional.of(clazz.cast(this.targetGroups()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private List<TargetGroup> targetGroups;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateTargetGroupResponse model) {
            this.targetGroups(model.targetGroups);
        }

        public final Collection<TargetGroup.Builder> getTargetGroups() {
            return this.targetGroups != null ? (Collection)this.targetGroups.stream().map(TargetGroup::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder targetGroups(Collection<TargetGroup> targetGroups) {
            this.targetGroups = TargetGroupsCopier.copy(targetGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder targetGroups(TargetGroup ... targetGroups) {
            this.targetGroups(Arrays.asList(targetGroups));
            return this;
        }

        public final void setTargetGroups(Collection<TargetGroup.BuilderImpl> targetGroups) {
            this.targetGroups = TargetGroupsCopier.copyFromBuilder(targetGroups);
        }

        public CreateTargetGroupResponse build() {
            return new CreateTargetGroupResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, CreateTargetGroupResponse> {
        public Builder targetGroups(Collection<TargetGroup> var1);

        public Builder targetGroups(TargetGroup ... var1);
    }
}

