/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticloadbalancingv2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.TargetGroupAttribute;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.TargetGroupAttributesCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ModifyTargetGroupAttributesRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, ModifyTargetGroupAttributesRequest> {
    private final String targetGroupArn;
    private final List<TargetGroupAttribute> attributes;

    private ModifyTargetGroupAttributesRequest(BuilderImpl builder) {
        this.targetGroupArn = builder.targetGroupArn;
        this.attributes = builder.attributes;
    }

    public String targetGroupArn() {
        return this.targetGroupArn;
    }

    public List<TargetGroupAttribute> attributes() {
        return this.attributes;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.targetGroupArn() == null ? 0 : this.targetGroupArn().hashCode());
        hashCode = 31 * hashCode + (this.attributes() == null ? 0 : this.attributes().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModifyTargetGroupAttributesRequest)) {
            return false;
        }
        ModifyTargetGroupAttributesRequest other = (ModifyTargetGroupAttributesRequest)((Object)obj);
        if (other.targetGroupArn() == null ^ this.targetGroupArn() == null) {
            return false;
        }
        if (other.targetGroupArn() != null && !other.targetGroupArn().equals(this.targetGroupArn())) {
            return false;
        }
        if (other.attributes() == null ^ this.attributes() == null) {
            return false;
        }
        return other.attributes() == null || other.attributes().equals(this.attributes());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.targetGroupArn() != null) {
            sb.append("TargetGroupArn: ").append(this.targetGroupArn()).append(",");
        }
        if (this.attributes() != null) {
            sb.append("Attributes: ").append(this.attributes()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TargetGroupArn": {
                return Optional.of(clazz.cast(this.targetGroupArn()));
            }
            case "Attributes": {
                return Optional.of(clazz.cast(this.attributes()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String targetGroupArn;
        private List<TargetGroupAttribute> attributes;

        private BuilderImpl() {
        }

        private BuilderImpl(ModifyTargetGroupAttributesRequest model) {
            this.targetGroupArn(model.targetGroupArn);
            this.attributes(model.attributes);
        }

        public final String getTargetGroupArn() {
            return this.targetGroupArn;
        }

        @Override
        public final Builder targetGroupArn(String targetGroupArn) {
            this.targetGroupArn = targetGroupArn;
            return this;
        }

        public final void setTargetGroupArn(String targetGroupArn) {
            this.targetGroupArn = targetGroupArn;
        }

        public final Collection<TargetGroupAttribute.Builder> getAttributes() {
            return this.attributes != null ? (Collection)this.attributes.stream().map(TargetGroupAttribute::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder attributes(Collection<TargetGroupAttribute> attributes) {
            this.attributes = TargetGroupAttributesCopier.copy(attributes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attributes(TargetGroupAttribute ... attributes) {
            this.attributes(Arrays.asList(attributes));
            return this;
        }

        public final void setAttributes(Collection<TargetGroupAttribute.BuilderImpl> attributes) {
            this.attributes = TargetGroupAttributesCopier.copyFromBuilder(attributes);
        }

        public ModifyTargetGroupAttributesRequest build() {
            return new ModifyTargetGroupAttributesRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ModifyTargetGroupAttributesRequest> {
        public Builder targetGroupArn(String var1);

        public Builder attributes(Collection<TargetGroupAttribute> var1);

        public Builder attributes(TargetGroupAttribute ... var1);
    }
}

