/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticloadbalancingv2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.core.AmazonWebServiceResult;
import software.amazon.awssdk.core.ResponseMetadata;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.LoadBalancerAttribute;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.LoadBalancerAttributesCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeLoadBalancerAttributesResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, DescribeLoadBalancerAttributesResponse> {
    private final List<LoadBalancerAttribute> attributes;

    private DescribeLoadBalancerAttributesResponse(BuilderImpl builder) {
        this.attributes = builder.attributes;
    }

    public List<LoadBalancerAttribute> attributes() {
        return this.attributes;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.attributes() == null ? 0 : this.attributes().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeLoadBalancerAttributesResponse)) {
            return false;
        }
        DescribeLoadBalancerAttributesResponse other = (DescribeLoadBalancerAttributesResponse)((Object)obj);
        if (other.attributes() == null ^ this.attributes() == null) {
            return false;
        }
        return other.attributes() == null || other.attributes().equals(this.attributes());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.attributes() != null) {
            sb.append("Attributes: ").append(this.attributes()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Attributes": {
                return Optional.of(clazz.cast(this.attributes()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private List<LoadBalancerAttribute> attributes;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeLoadBalancerAttributesResponse model) {
            this.attributes(model.attributes);
        }

        public final Collection<LoadBalancerAttribute.Builder> getAttributes() {
            return this.attributes != null ? (Collection)this.attributes.stream().map(LoadBalancerAttribute::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder attributes(Collection<LoadBalancerAttribute> attributes) {
            this.attributes = LoadBalancerAttributesCopier.copy(attributes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attributes(LoadBalancerAttribute ... attributes) {
            this.attributes(Arrays.asList(attributes));
            return this;
        }

        public final void setAttributes(Collection<LoadBalancerAttribute.BuilderImpl> attributes) {
            this.attributes = LoadBalancerAttributesCopier.copyFromBuilder(attributes);
        }

        public DescribeLoadBalancerAttributesResponse build() {
            return new DescribeLoadBalancerAttributesResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DescribeLoadBalancerAttributesResponse> {
        public Builder attributes(Collection<LoadBalancerAttribute> var1);

        public Builder attributes(LoadBalancerAttribute ... var1);
    }
}

