/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticloadbalancingv2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.core.AmazonWebServiceResult;
import software.amazon.awssdk.core.ResponseMetadata;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.Limit;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.LimitsCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeAccountLimitsResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, DescribeAccountLimitsResponse> {
    private final List<Limit> limits;
    private final String nextMarker;

    private DescribeAccountLimitsResponse(BuilderImpl builder) {
        this.limits = builder.limits;
        this.nextMarker = builder.nextMarker;
    }

    public List<Limit> limits() {
        return this.limits;
    }

    public String nextMarker() {
        return this.nextMarker;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.limits() == null ? 0 : this.limits().hashCode());
        hashCode = 31 * hashCode + (this.nextMarker() == null ? 0 : this.nextMarker().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeAccountLimitsResponse)) {
            return false;
        }
        DescribeAccountLimitsResponse other = (DescribeAccountLimitsResponse)((Object)obj);
        if (other.limits() == null ^ this.limits() == null) {
            return false;
        }
        if (other.limits() != null && !other.limits().equals(this.limits())) {
            return false;
        }
        if (other.nextMarker() == null ^ this.nextMarker() == null) {
            return false;
        }
        return other.nextMarker() == null || other.nextMarker().equals(this.nextMarker());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.limits() != null) {
            sb.append("Limits: ").append(this.limits()).append(",");
        }
        if (this.nextMarker() != null) {
            sb.append("NextMarker: ").append(this.nextMarker()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Limits": {
                return Optional.of(clazz.cast(this.limits()));
            }
            case "NextMarker": {
                return Optional.of(clazz.cast(this.nextMarker()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private List<Limit> limits;
        private String nextMarker;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeAccountLimitsResponse model) {
            this.limits(model.limits);
            this.nextMarker(model.nextMarker);
        }

        public final Collection<Limit.Builder> getLimits() {
            return this.limits != null ? (Collection)this.limits.stream().map(Limit::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder limits(Collection<Limit> limits) {
            this.limits = LimitsCopier.copy(limits);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder limits(Limit ... limits) {
            this.limits(Arrays.asList(limits));
            return this;
        }

        public final void setLimits(Collection<Limit.BuilderImpl> limits) {
            this.limits = LimitsCopier.copyFromBuilder(limits);
        }

        public final String getNextMarker() {
            return this.nextMarker;
        }

        @Override
        public final Builder nextMarker(String nextMarker) {
            this.nextMarker = nextMarker;
            return this;
        }

        public final void setNextMarker(String nextMarker) {
            this.nextMarker = nextMarker;
        }

        public DescribeAccountLimitsResponse build() {
            return new DescribeAccountLimitsResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DescribeAccountLimitsResponse> {
        public Builder limits(Collection<Limit> var1);

        public Builder limits(Limit ... var1);

        public Builder nextMarker(String var1);
    }
}

