/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticloadbalancingv2.waiters;

import com.fasterxml.jackson.databind.JsonNode;
import io.burt.jmespath.Expression;
import io.burt.jmespath.jackson.JacksonRuntime;
import java.io.IOException;
import software.amazon.awssdk.AmazonServiceException;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeLoadBalancersResponse;
import software.amazon.awssdk.waiters.AcceptorPathMatcher;
import software.amazon.awssdk.waiters.ObjectMapperSingleton;
import software.amazon.awssdk.waiters.WaiterAcceptor;
import software.amazon.awssdk.waiters.WaiterState;

@SdkInternalApi
class LoadBalancerAvailable {
    LoadBalancerAvailable() {
    }

    static class IsLoadBalancerNotFoundMatcher
    extends WaiterAcceptor<DescribeLoadBalancersResponse> {
        IsLoadBalancerNotFoundMatcher() {
        }

        public boolean matches(AmazonServiceException e) {
            return "LoadBalancerNotFound".equals(e.getErrorCode());
        }

        public WaiterState getState() {
            return WaiterState.RETRY;
        }
    }

    static class IsProvisioningMatcher
    extends WaiterAcceptor<DescribeLoadBalancersResponse> {
        private static final JsonNode EXPECTED_RESULT;
        private static final Expression<JsonNode> AST;

        IsProvisioningMatcher() {
        }

        public boolean matches(DescribeLoadBalancersResponse result) {
            JsonNode queryNode = ObjectMapperSingleton.getObjectMapper().valueToTree((Object)result);
            JsonNode finalResult = (JsonNode)AST.search((Object)queryNode);
            return AcceptorPathMatcher.pathAny((JsonNode)EXPECTED_RESULT, (JsonNode)finalResult);
        }

        public WaiterState getState() {
            return WaiterState.RETRY;
        }

        static {
            try {
                EXPECTED_RESULT = ObjectMapperSingleton.getObjectMapper().readTree("\"provisioning\"");
            }
            catch (IOException ioe) {
                throw new RuntimeException(ioe);
            }
            AST = new JacksonRuntime().compile("loadBalancers[].state.code");
        }
    }

    static class IsActiveMatcher
    extends WaiterAcceptor<DescribeLoadBalancersResponse> {
        private static final JsonNode EXPECTED_RESULT;
        private static final Expression<JsonNode> AST;

        IsActiveMatcher() {
        }

        public boolean matches(DescribeLoadBalancersResponse result) {
            JsonNode queryNode = ObjectMapperSingleton.getObjectMapper().valueToTree((Object)result);
            JsonNode finalResult = (JsonNode)AST.search((Object)queryNode);
            return AcceptorPathMatcher.pathAll((JsonNode)EXPECTED_RESULT, (JsonNode)finalResult);
        }

        public WaiterState getState() {
            return WaiterState.SUCCESS;
        }

        static {
            try {
                EXPECTED_RESULT = ObjectMapperSingleton.getObjectMapper().readTree("\"active\"");
            }
            catch (IOException ioe) {
                throw new RuntimeException(ioe);
            }
            AST = new JacksonRuntime().compile("loadBalancers[].state.code");
        }
    }
}

