/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticloadbalancingv2.transform;

import java.util.List;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.DeregisterTargetsRequest;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.TargetDescription;
import software.amazon.awssdk.util.StringUtils;

public class DeregisterTargetsRequestMarshaller
implements Marshaller<Request<DeregisterTargetsRequest>, DeregisterTargetsRequest> {
    public Request<DeregisterTargetsRequest> marshall(DeregisterTargetsRequest deregisterTargetsRequest) {
        List<TargetDescription> targetsList;
        if (deregisterTargetsRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)deregisterTargetsRequest, "ElasticLoadBalancingv2Client");
        request.addParameter("Action", "DeregisterTargets");
        request.addParameter("Version", "2015-12-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (deregisterTargetsRequest.targetGroupArn() != null) {
            request.addParameter("TargetGroupArn", StringUtils.fromString((String)deregisterTargetsRequest.targetGroupArn()));
        }
        if ((targetsList = deregisterTargetsRequest.targets()) != null) {
            if (!targetsList.isEmpty()) {
                int targetsListIndex = 1;
                for (TargetDescription targetsListValue : targetsList) {
                    if (targetsListValue.id() != null) {
                        request.addParameter("Targets.member." + targetsListIndex + ".Id", StringUtils.fromString((String)targetsListValue.id()));
                    }
                    if (targetsListValue.port() != null) {
                        request.addParameter("Targets.member." + targetsListIndex + ".Port", StringUtils.fromInteger((Integer)targetsListValue.port()));
                    }
                    ++targetsListIndex;
                }
            } else {
                request.addParameter("Targets", "");
            }
        }
        return request;
    }
}

