/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticloadbalancingv2.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.AvailabilityZone;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.AvailabilityZonesCopier;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.IpAddressType;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.LoadBalancerSchemeEnum;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.LoadBalancerState;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.LoadBalancerTypeEnum;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.SecurityGroupsCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class LoadBalancer
implements ToCopyableBuilder<Builder, LoadBalancer> {
    private final String loadBalancerArn;
    private final String dnsName;
    private final String canonicalHostedZoneId;
    private final Instant createdTime;
    private final String loadBalancerName;
    private final String scheme;
    private final String vpcId;
    private final LoadBalancerState state;
    private final String type;
    private final List<AvailabilityZone> availabilityZones;
    private final List<String> securityGroups;
    private final String ipAddressType;

    private LoadBalancer(BuilderImpl builder) {
        this.loadBalancerArn = builder.loadBalancerArn;
        this.dnsName = builder.dnsName;
        this.canonicalHostedZoneId = builder.canonicalHostedZoneId;
        this.createdTime = builder.createdTime;
        this.loadBalancerName = builder.loadBalancerName;
        this.scheme = builder.scheme;
        this.vpcId = builder.vpcId;
        this.state = builder.state;
        this.type = builder.type;
        this.availabilityZones = builder.availabilityZones;
        this.securityGroups = builder.securityGroups;
        this.ipAddressType = builder.ipAddressType;
    }

    public String loadBalancerArn() {
        return this.loadBalancerArn;
    }

    public String dnsName() {
        return this.dnsName;
    }

    public String canonicalHostedZoneId() {
        return this.canonicalHostedZoneId;
    }

    public Instant createdTime() {
        return this.createdTime;
    }

    public String loadBalancerName() {
        return this.loadBalancerName;
    }

    public String scheme() {
        return this.scheme;
    }

    public String vpcId() {
        return this.vpcId;
    }

    public LoadBalancerState state() {
        return this.state;
    }

    public String type() {
        return this.type;
    }

    public List<AvailabilityZone> availabilityZones() {
        return this.availabilityZones;
    }

    public List<String> securityGroups() {
        return this.securityGroups;
    }

    public String ipAddressType() {
        return this.ipAddressType;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.loadBalancerArn() == null ? 0 : this.loadBalancerArn().hashCode());
        hashCode = 31 * hashCode + (this.dnsName() == null ? 0 : this.dnsName().hashCode());
        hashCode = 31 * hashCode + (this.canonicalHostedZoneId() == null ? 0 : this.canonicalHostedZoneId().hashCode());
        hashCode = 31 * hashCode + (this.createdTime() == null ? 0 : this.createdTime().hashCode());
        hashCode = 31 * hashCode + (this.loadBalancerName() == null ? 0 : this.loadBalancerName().hashCode());
        hashCode = 31 * hashCode + (this.scheme() == null ? 0 : this.scheme().hashCode());
        hashCode = 31 * hashCode + (this.vpcId() == null ? 0 : this.vpcId().hashCode());
        hashCode = 31 * hashCode + (this.state() == null ? 0 : this.state().hashCode());
        hashCode = 31 * hashCode + (this.type() == null ? 0 : this.type().hashCode());
        hashCode = 31 * hashCode + (this.availabilityZones() == null ? 0 : this.availabilityZones().hashCode());
        hashCode = 31 * hashCode + (this.securityGroups() == null ? 0 : this.securityGroups().hashCode());
        hashCode = 31 * hashCode + (this.ipAddressType() == null ? 0 : this.ipAddressType().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LoadBalancer)) {
            return false;
        }
        LoadBalancer other = (LoadBalancer)obj;
        if (other.loadBalancerArn() == null ^ this.loadBalancerArn() == null) {
            return false;
        }
        if (other.loadBalancerArn() != null && !other.loadBalancerArn().equals(this.loadBalancerArn())) {
            return false;
        }
        if (other.dnsName() == null ^ this.dnsName() == null) {
            return false;
        }
        if (other.dnsName() != null && !other.dnsName().equals(this.dnsName())) {
            return false;
        }
        if (other.canonicalHostedZoneId() == null ^ this.canonicalHostedZoneId() == null) {
            return false;
        }
        if (other.canonicalHostedZoneId() != null && !other.canonicalHostedZoneId().equals(this.canonicalHostedZoneId())) {
            return false;
        }
        if (other.createdTime() == null ^ this.createdTime() == null) {
            return false;
        }
        if (other.createdTime() != null && !other.createdTime().equals(this.createdTime())) {
            return false;
        }
        if (other.loadBalancerName() == null ^ this.loadBalancerName() == null) {
            return false;
        }
        if (other.loadBalancerName() != null && !other.loadBalancerName().equals(this.loadBalancerName())) {
            return false;
        }
        if (other.scheme() == null ^ this.scheme() == null) {
            return false;
        }
        if (other.scheme() != null && !other.scheme().equals(this.scheme())) {
            return false;
        }
        if (other.vpcId() == null ^ this.vpcId() == null) {
            return false;
        }
        if (other.vpcId() != null && !other.vpcId().equals(this.vpcId())) {
            return false;
        }
        if (other.state() == null ^ this.state() == null) {
            return false;
        }
        if (other.state() != null && !other.state().equals(this.state())) {
            return false;
        }
        if (other.type() == null ^ this.type() == null) {
            return false;
        }
        if (other.type() != null && !other.type().equals(this.type())) {
            return false;
        }
        if (other.availabilityZones() == null ^ this.availabilityZones() == null) {
            return false;
        }
        if (other.availabilityZones() != null && !other.availabilityZones().equals(this.availabilityZones())) {
            return false;
        }
        if (other.securityGroups() == null ^ this.securityGroups() == null) {
            return false;
        }
        if (other.securityGroups() != null && !other.securityGroups().equals(this.securityGroups())) {
            return false;
        }
        if (other.ipAddressType() == null ^ this.ipAddressType() == null) {
            return false;
        }
        return other.ipAddressType() == null || other.ipAddressType().equals(this.ipAddressType());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.loadBalancerArn() != null) {
            sb.append("LoadBalancerArn: ").append(this.loadBalancerArn()).append(",");
        }
        if (this.dnsName() != null) {
            sb.append("DNSName: ").append(this.dnsName()).append(",");
        }
        if (this.canonicalHostedZoneId() != null) {
            sb.append("CanonicalHostedZoneId: ").append(this.canonicalHostedZoneId()).append(",");
        }
        if (this.createdTime() != null) {
            sb.append("CreatedTime: ").append(this.createdTime()).append(",");
        }
        if (this.loadBalancerName() != null) {
            sb.append("LoadBalancerName: ").append(this.loadBalancerName()).append(",");
        }
        if (this.scheme() != null) {
            sb.append("Scheme: ").append(this.scheme()).append(",");
        }
        if (this.vpcId() != null) {
            sb.append("VpcId: ").append(this.vpcId()).append(",");
        }
        if (this.state() != null) {
            sb.append("State: ").append(this.state()).append(",");
        }
        if (this.type() != null) {
            sb.append("Type: ").append(this.type()).append(",");
        }
        if (this.availabilityZones() != null) {
            sb.append("AvailabilityZones: ").append(this.availabilityZones()).append(",");
        }
        if (this.securityGroups() != null) {
            sb.append("SecurityGroups: ").append(this.securityGroups()).append(",");
        }
        if (this.ipAddressType() != null) {
            sb.append("IpAddressType: ").append(this.ipAddressType()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String loadBalancerArn;
        private String dnsName;
        private String canonicalHostedZoneId;
        private Instant createdTime;
        private String loadBalancerName;
        private String scheme;
        private String vpcId;
        private LoadBalancerState state;
        private String type;
        private List<AvailabilityZone> availabilityZones;
        private List<String> securityGroups;
        private String ipAddressType;

        private BuilderImpl() {
        }

        private BuilderImpl(LoadBalancer model) {
            this.setLoadBalancerArn(model.loadBalancerArn);
            this.setDNSName(model.dnsName);
            this.setCanonicalHostedZoneId(model.canonicalHostedZoneId);
            this.setCreatedTime(model.createdTime);
            this.setLoadBalancerName(model.loadBalancerName);
            this.setScheme(model.scheme);
            this.setVpcId(model.vpcId);
            this.setState(model.state);
            this.setType(model.type);
            this.setAvailabilityZones(model.availabilityZones);
            this.setSecurityGroups(model.securityGroups);
            this.setIpAddressType(model.ipAddressType);
        }

        public final String getLoadBalancerArn() {
            return this.loadBalancerArn;
        }

        @Override
        public final Builder loadBalancerArn(String loadBalancerArn) {
            this.loadBalancerArn = loadBalancerArn;
            return this;
        }

        public final void setLoadBalancerArn(String loadBalancerArn) {
            this.loadBalancerArn = loadBalancerArn;
        }

        public final String getDNSName() {
            return this.dnsName;
        }

        @Override
        public final Builder dnsName(String dnsName) {
            this.dnsName = dnsName;
            return this;
        }

        public final void setDNSName(String dnsName) {
            this.dnsName = dnsName;
        }

        public final String getCanonicalHostedZoneId() {
            return this.canonicalHostedZoneId;
        }

        @Override
        public final Builder canonicalHostedZoneId(String canonicalHostedZoneId) {
            this.canonicalHostedZoneId = canonicalHostedZoneId;
            return this;
        }

        public final void setCanonicalHostedZoneId(String canonicalHostedZoneId) {
            this.canonicalHostedZoneId = canonicalHostedZoneId;
        }

        public final Instant getCreatedTime() {
            return this.createdTime;
        }

        @Override
        public final Builder createdTime(Instant createdTime) {
            this.createdTime = createdTime;
            return this;
        }

        public final void setCreatedTime(Instant createdTime) {
            this.createdTime = createdTime;
        }

        public final String getLoadBalancerName() {
            return this.loadBalancerName;
        }

        @Override
        public final Builder loadBalancerName(String loadBalancerName) {
            this.loadBalancerName = loadBalancerName;
            return this;
        }

        public final void setLoadBalancerName(String loadBalancerName) {
            this.loadBalancerName = loadBalancerName;
        }

        public final String getScheme() {
            return this.scheme;
        }

        @Override
        public final Builder scheme(String scheme) {
            this.scheme = scheme;
            return this;
        }

        @Override
        public final Builder scheme(LoadBalancerSchemeEnum scheme) {
            this.scheme(scheme.toString());
            return this;
        }

        public final void setScheme(String scheme) {
            this.scheme = scheme;
        }

        public final void setScheme(LoadBalancerSchemeEnum scheme) {
            this.scheme(scheme.toString());
        }

        public final String getVpcId() {
            return this.vpcId;
        }

        @Override
        public final Builder vpcId(String vpcId) {
            this.vpcId = vpcId;
            return this;
        }

        public final void setVpcId(String vpcId) {
            this.vpcId = vpcId;
        }

        public final LoadBalancerState getState() {
            return this.state;
        }

        @Override
        public final Builder state(LoadBalancerState state) {
            this.state = state;
            return this;
        }

        public final void setState(LoadBalancerState state) {
            this.state = state;
        }

        public final String getType() {
            return this.type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(LoadBalancerTypeEnum type) {
            this.type(type.toString());
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        public final void setType(LoadBalancerTypeEnum type) {
            this.type(type.toString());
        }

        public final Collection<AvailabilityZone> getAvailabilityZones() {
            return this.availabilityZones;
        }

        @Override
        public final Builder availabilityZones(Collection<AvailabilityZone> availabilityZones) {
            this.availabilityZones = AvailabilityZonesCopier.copy(availabilityZones);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder availabilityZones(AvailabilityZone ... availabilityZones) {
            this.availabilityZones(Arrays.asList(availabilityZones));
            return this;
        }

        public final void setAvailabilityZones(Collection<AvailabilityZone> availabilityZones) {
            this.availabilityZones = AvailabilityZonesCopier.copy(availabilityZones);
        }

        @SafeVarargs
        public final void setAvailabilityZones(AvailabilityZone ... availabilityZones) {
            this.availabilityZones(Arrays.asList(availabilityZones));
        }

        public final Collection<String> getSecurityGroups() {
            return this.securityGroups;
        }

        @Override
        public final Builder securityGroups(Collection<String> securityGroups) {
            this.securityGroups = SecurityGroupsCopier.copy(securityGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder securityGroups(String ... securityGroups) {
            this.securityGroups(Arrays.asList(securityGroups));
            return this;
        }

        public final void setSecurityGroups(Collection<String> securityGroups) {
            this.securityGroups = SecurityGroupsCopier.copy(securityGroups);
        }

        @SafeVarargs
        public final void setSecurityGroups(String ... securityGroups) {
            this.securityGroups(Arrays.asList(securityGroups));
        }

        public final String getIpAddressType() {
            return this.ipAddressType;
        }

        @Override
        public final Builder ipAddressType(String ipAddressType) {
            this.ipAddressType = ipAddressType;
            return this;
        }

        @Override
        public final Builder ipAddressType(IpAddressType ipAddressType) {
            this.ipAddressType(ipAddressType.toString());
            return this;
        }

        public final void setIpAddressType(String ipAddressType) {
            this.ipAddressType = ipAddressType;
        }

        public final void setIpAddressType(IpAddressType ipAddressType) {
            this.ipAddressType(ipAddressType.toString());
        }

        public LoadBalancer build() {
            return new LoadBalancer(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, LoadBalancer> {
        public Builder loadBalancerArn(String var1);

        public Builder dnsName(String var1);

        public Builder canonicalHostedZoneId(String var1);

        public Builder createdTime(Instant var1);

        public Builder loadBalancerName(String var1);

        public Builder scheme(String var1);

        public Builder scheme(LoadBalancerSchemeEnum var1);

        public Builder vpcId(String var1);

        public Builder state(LoadBalancerState var1);

        public Builder type(String var1);

        public Builder type(LoadBalancerTypeEnum var1);

        public Builder availabilityZones(Collection<AvailabilityZone> var1);

        public Builder availabilityZones(AvailabilityZone ... var1);

        public Builder securityGroups(Collection<String> var1);

        public Builder securityGroups(String ... var1);

        public Builder ipAddressType(String var1);

        public Builder ipAddressType(IpAddressType var1);
    }
}

