/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticloadbalancingv2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.Action;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.ActionsCopier;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.RuleCondition;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.RuleConditionListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class CreateRuleRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, CreateRuleRequest> {
    private final String listenerArn;
    private final List<RuleCondition> conditions;
    private final Integer priority;
    private final List<Action> actions;

    private CreateRuleRequest(BuilderImpl builder) {
        this.listenerArn = builder.listenerArn;
        this.conditions = builder.conditions;
        this.priority = builder.priority;
        this.actions = builder.actions;
    }

    public String listenerArn() {
        return this.listenerArn;
    }

    public List<RuleCondition> conditions() {
        return this.conditions;
    }

    public Integer priority() {
        return this.priority;
    }

    public List<Action> actions() {
        return this.actions;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.listenerArn() == null ? 0 : this.listenerArn().hashCode());
        hashCode = 31 * hashCode + (this.conditions() == null ? 0 : this.conditions().hashCode());
        hashCode = 31 * hashCode + (this.priority() == null ? 0 : this.priority().hashCode());
        hashCode = 31 * hashCode + (this.actions() == null ? 0 : this.actions().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateRuleRequest)) {
            return false;
        }
        CreateRuleRequest other = (CreateRuleRequest)((Object)obj);
        if (other.listenerArn() == null ^ this.listenerArn() == null) {
            return false;
        }
        if (other.listenerArn() != null && !other.listenerArn().equals(this.listenerArn())) {
            return false;
        }
        if (other.conditions() == null ^ this.conditions() == null) {
            return false;
        }
        if (other.conditions() != null && !other.conditions().equals(this.conditions())) {
            return false;
        }
        if (other.priority() == null ^ this.priority() == null) {
            return false;
        }
        if (other.priority() != null && !other.priority().equals(this.priority())) {
            return false;
        }
        if (other.actions() == null ^ this.actions() == null) {
            return false;
        }
        return other.actions() == null || other.actions().equals(this.actions());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.listenerArn() != null) {
            sb.append("ListenerArn: ").append(this.listenerArn()).append(",");
        }
        if (this.conditions() != null) {
            sb.append("Conditions: ").append(this.conditions()).append(",");
        }
        if (this.priority() != null) {
            sb.append("Priority: ").append(this.priority()).append(",");
        }
        if (this.actions() != null) {
            sb.append("Actions: ").append(this.actions()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String listenerArn;
        private List<RuleCondition> conditions;
        private Integer priority;
        private List<Action> actions;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateRuleRequest model) {
            this.setListenerArn(model.listenerArn);
            this.setConditions(model.conditions);
            this.setPriority(model.priority);
            this.setActions(model.actions);
        }

        public final String getListenerArn() {
            return this.listenerArn;
        }

        @Override
        public final Builder listenerArn(String listenerArn) {
            this.listenerArn = listenerArn;
            return this;
        }

        public final void setListenerArn(String listenerArn) {
            this.listenerArn = listenerArn;
        }

        public final Collection<RuleCondition> getConditions() {
            return this.conditions;
        }

        @Override
        public final Builder conditions(Collection<RuleCondition> conditions) {
            this.conditions = RuleConditionListCopier.copy(conditions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder conditions(RuleCondition ... conditions) {
            this.conditions(Arrays.asList(conditions));
            return this;
        }

        public final void setConditions(Collection<RuleCondition> conditions) {
            this.conditions = RuleConditionListCopier.copy(conditions);
        }

        @SafeVarargs
        public final void setConditions(RuleCondition ... conditions) {
            this.conditions(Arrays.asList(conditions));
        }

        public final Integer getPriority() {
            return this.priority;
        }

        @Override
        public final Builder priority(Integer priority) {
            this.priority = priority;
            return this;
        }

        public final void setPriority(Integer priority) {
            this.priority = priority;
        }

        public final Collection<Action> getActions() {
            return this.actions;
        }

        @Override
        public final Builder actions(Collection<Action> actions) {
            this.actions = ActionsCopier.copy(actions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder actions(Action ... actions) {
            this.actions(Arrays.asList(actions));
            return this;
        }

        public final void setActions(Collection<Action> actions) {
            this.actions = ActionsCopier.copy(actions);
        }

        @SafeVarargs
        public final void setActions(Action ... actions) {
            this.actions(Arrays.asList(actions));
        }

        public CreateRuleRequest build() {
            return new CreateRuleRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, CreateRuleRequest> {
        public Builder listenerArn(String var1);

        public Builder conditions(Collection<RuleCondition> var1);

        public Builder conditions(RuleCondition ... var1);

        public Builder priority(Integer var1);

        public Builder actions(Collection<Action> var1);

        public Builder actions(Action ... var1);
    }
}

