/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticloadbalancingv2.transform;

import java.util.List;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.RegisterTargetsRequest;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.TargetDescription;

public class RegisterTargetsRequestMarshaller
implements Marshaller<Request<RegisterTargetsRequest>, RegisterTargetsRequest> {
    public Request<RegisterTargetsRequest> marshall(RegisterTargetsRequest registerTargetsRequest) {
        if (registerTargetsRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)registerTargetsRequest, "ElasticLoadBalancingV2Client");
        request.addParameter("Action", "RegisterTargets");
        request.addParameter("Version", "2015-12-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (registerTargetsRequest.targetGroupArn() != null) {
            request.addParameter("TargetGroupArn", StringConversion.fromString((String)registerTargetsRequest.targetGroupArn()));
        }
        if (registerTargetsRequest.targets().isEmpty() && !(registerTargetsRequest.targets() instanceof SdkAutoConstructList)) {
            request.addParameter("Targets", "");
        } else if (!registerTargetsRequest.targets().isEmpty() && !(registerTargetsRequest.targets() instanceof SdkAutoConstructList)) {
            List<TargetDescription> targetsList = registerTargetsRequest.targets();
            int targetsListIndex = 1;
            for (TargetDescription targetsListValue : targetsList) {
                if (targetsListValue.id() != null) {
                    request.addParameter("Targets.member." + targetsListIndex + ".Id", StringConversion.fromString((String)targetsListValue.id()));
                }
                if (targetsListValue.port() != null) {
                    request.addParameter("Targets.member." + targetsListIndex + ".Port", StringConversion.fromInteger((Integer)targetsListValue.port()));
                }
                if (targetsListValue.availabilityZone() != null) {
                    request.addParameter("Targets.member." + targetsListIndex + ".AvailabilityZone", StringConversion.fromString((String)targetsListValue.availabilityZone()));
                }
                ++targetsListIndex;
            }
        }
        return request;
    }
}

