/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticloadbalancingv2.transform;

import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.Matcher;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.ModifyTargetGroupRequest;

public class ModifyTargetGroupRequestMarshaller
implements Marshaller<Request<ModifyTargetGroupRequest>, ModifyTargetGroupRequest> {
    public Request<ModifyTargetGroupRequest> marshall(ModifyTargetGroupRequest modifyTargetGroupRequest) {
        Matcher matcher;
        if (modifyTargetGroupRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)modifyTargetGroupRequest, "ElasticLoadBalancingV2Client");
        request.addParameter("Action", "ModifyTargetGroup");
        request.addParameter("Version", "2015-12-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (modifyTargetGroupRequest.targetGroupArn() != null) {
            request.addParameter("TargetGroupArn", StringConversion.fromString((String)modifyTargetGroupRequest.targetGroupArn()));
        }
        if (modifyTargetGroupRequest.healthCheckProtocolAsString() != null) {
            request.addParameter("HealthCheckProtocol", StringConversion.fromString((String)modifyTargetGroupRequest.healthCheckProtocolAsString()));
        }
        if (modifyTargetGroupRequest.healthCheckPort() != null) {
            request.addParameter("HealthCheckPort", StringConversion.fromString((String)modifyTargetGroupRequest.healthCheckPort()));
        }
        if (modifyTargetGroupRequest.healthCheckPath() != null) {
            request.addParameter("HealthCheckPath", StringConversion.fromString((String)modifyTargetGroupRequest.healthCheckPath()));
        }
        if (modifyTargetGroupRequest.healthCheckIntervalSeconds() != null) {
            request.addParameter("HealthCheckIntervalSeconds", StringConversion.fromInteger((Integer)modifyTargetGroupRequest.healthCheckIntervalSeconds()));
        }
        if (modifyTargetGroupRequest.healthCheckTimeoutSeconds() != null) {
            request.addParameter("HealthCheckTimeoutSeconds", StringConversion.fromInteger((Integer)modifyTargetGroupRequest.healthCheckTimeoutSeconds()));
        }
        if (modifyTargetGroupRequest.healthyThresholdCount() != null) {
            request.addParameter("HealthyThresholdCount", StringConversion.fromInteger((Integer)modifyTargetGroupRequest.healthyThresholdCount()));
        }
        if (modifyTargetGroupRequest.unhealthyThresholdCount() != null) {
            request.addParameter("UnhealthyThresholdCount", StringConversion.fromInteger((Integer)modifyTargetGroupRequest.unhealthyThresholdCount()));
        }
        if ((matcher = modifyTargetGroupRequest.matcher()) != null && matcher.httpCode() != null) {
            request.addParameter("Matcher.HttpCode", StringConversion.fromString((String)matcher.httpCode()));
        }
        return request;
    }
}

