/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticloadbalancingv2.transform;

import java.util.List;
import java.util.Map;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.Action;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.AuthenticateCognitoActionConfig;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.AuthenticateOidcActionConfig;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.CreateRuleRequest;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.FixedResponseActionConfig;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.RedirectActionConfig;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.RuleCondition;

public class CreateRuleRequestMarshaller
implements Marshaller<Request<CreateRuleRequest>, CreateRuleRequest> {
    /*
     * WARNING - void declaration
     */
    public Request<CreateRuleRequest> marshall(CreateRuleRequest createRuleRequest) {
        if (createRuleRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)createRuleRequest, "ElasticLoadBalancingV2Client");
        request.addParameter("Action", "CreateRule");
        request.addParameter("Version", "2015-12-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (createRuleRequest.listenerArn() != null) {
            request.addParameter("ListenerArn", StringConversion.fromString((String)createRuleRequest.listenerArn()));
        }
        if (createRuleRequest.conditions().isEmpty() && !(createRuleRequest.conditions() instanceof SdkAutoConstructList)) {
            request.addParameter("Conditions", "");
        } else if (!createRuleRequest.conditions().isEmpty() && !(createRuleRequest.conditions() instanceof SdkAutoConstructList)) {
            List<RuleCondition> conditionsList = createRuleRequest.conditions();
            int conditionsListIndex = 1;
            for (RuleCondition conditionsListValue : conditionsList) {
                if (conditionsListValue.field() != null) {
                    request.addParameter("Conditions.member." + conditionsListIndex + ".Field", StringConversion.fromString((String)conditionsListValue.field()));
                }
                if (conditionsListValue.values().isEmpty() && !(conditionsListValue.values() instanceof SdkAutoConstructList)) {
                    request.addParameter("Conditions.member." + conditionsListIndex + ".Values", "");
                } else if (!conditionsListValue.values().isEmpty() && !(conditionsListValue.values() instanceof SdkAutoConstructList)) {
                    List<String> valuesList = conditionsListValue.values();
                    int valuesListIndex = 1;
                    for (String string : valuesList) {
                        if (string != null) {
                            request.addParameter("Conditions.member." + conditionsListIndex + ".Values.member." + valuesListIndex, StringConversion.fromString((String)string));
                        }
                        ++valuesListIndex;
                    }
                }
                ++conditionsListIndex;
            }
        }
        if (createRuleRequest.priority() != null) {
            request.addParameter("Priority", StringConversion.fromInteger((Integer)createRuleRequest.priority()));
        }
        if (createRuleRequest.actions().isEmpty() && !(createRuleRequest.actions() instanceof SdkAutoConstructList)) {
            request.addParameter("Actions", "");
        } else if (!createRuleRequest.actions().isEmpty() && !(createRuleRequest.actions() instanceof SdkAutoConstructList)) {
            List<Action> actionsList = createRuleRequest.actions();
            int actionsListIndex = 1;
            for (Action actionsListValue : actionsList) {
                FixedResponseActionConfig fixedResponseActionConfig;
                RedirectActionConfig redirectConfig;
                AuthenticateCognitoActionConfig authenticateCognitoConfig;
                AuthenticateOidcActionConfig authenticateOidcConfig;
                if (actionsListValue.typeAsString() != null) {
                    request.addParameter("Actions.member." + actionsListIndex + ".Type", StringConversion.fromString((String)actionsListValue.typeAsString()));
                }
                if (actionsListValue.targetGroupArn() != null) {
                    request.addParameter("Actions.member." + actionsListIndex + ".TargetGroupArn", StringConversion.fromString((String)actionsListValue.targetGroupArn()));
                }
                if ((authenticateOidcConfig = actionsListValue.authenticateOidcConfig()) != null) {
                    Map<String, String> authenticationRequestExtraParams;
                    if (authenticateOidcConfig.issuer() != null) {
                        request.addParameter("Actions.member." + actionsListIndex + ".AuthenticateOidcConfig.Issuer", StringConversion.fromString((String)authenticateOidcConfig.issuer()));
                    }
                    if (authenticateOidcConfig.authorizationEndpoint() != null) {
                        request.addParameter("Actions.member." + actionsListIndex + ".AuthenticateOidcConfig.AuthorizationEndpoint", StringConversion.fromString((String)authenticateOidcConfig.authorizationEndpoint()));
                    }
                    if (authenticateOidcConfig.tokenEndpoint() != null) {
                        request.addParameter("Actions.member." + actionsListIndex + ".AuthenticateOidcConfig.TokenEndpoint", StringConversion.fromString((String)authenticateOidcConfig.tokenEndpoint()));
                    }
                    if (authenticateOidcConfig.userInfoEndpoint() != null) {
                        request.addParameter("Actions.member." + actionsListIndex + ".AuthenticateOidcConfig.UserInfoEndpoint", StringConversion.fromString((String)authenticateOidcConfig.userInfoEndpoint()));
                    }
                    if (authenticateOidcConfig.clientId() != null) {
                        request.addParameter("Actions.member." + actionsListIndex + ".AuthenticateOidcConfig.ClientId", StringConversion.fromString((String)authenticateOidcConfig.clientId()));
                    }
                    if (authenticateOidcConfig.clientSecret() != null) {
                        request.addParameter("Actions.member." + actionsListIndex + ".AuthenticateOidcConfig.ClientSecret", StringConversion.fromString((String)authenticateOidcConfig.clientSecret()));
                    }
                    if (authenticateOidcConfig.sessionCookieName() != null) {
                        request.addParameter("Actions.member." + actionsListIndex + ".AuthenticateOidcConfig.SessionCookieName", StringConversion.fromString((String)authenticateOidcConfig.sessionCookieName()));
                    }
                    if (authenticateOidcConfig.scope() != null) {
                        request.addParameter("Actions.member." + actionsListIndex + ".AuthenticateOidcConfig.Scope", StringConversion.fromString((String)authenticateOidcConfig.scope()));
                    }
                    if (authenticateOidcConfig.sessionTimeout() != null) {
                        request.addParameter("Actions.member." + actionsListIndex + ".AuthenticateOidcConfig.SessionTimeout", StringConversion.fromLong((Long)authenticateOidcConfig.sessionTimeout()));
                    }
                    if ((authenticationRequestExtraParams = authenticateOidcConfig.authenticationRequestExtraParams()) != null) {
                        int authenticationRequestExtraParamsListIndex = 1;
                        for (Map.Entry<String, String> entry : authenticationRequestExtraParams.entrySet()) {
                            if (entry.getKey() != null) {
                                request.addParameter("Actions.member." + actionsListIndex + ".AuthenticateOidcConfig.AuthenticationRequestExtraParams.entry." + authenticationRequestExtraParamsListIndex + ".key", StringConversion.fromString((String)entry.getKey()));
                            }
                            if (entry.getValue() != null) {
                                request.addParameter("Actions.member." + actionsListIndex + ".AuthenticateOidcConfig.AuthenticationRequestExtraParams.entry." + authenticationRequestExtraParamsListIndex + ".value", StringConversion.fromString((String)entry.getValue()));
                            }
                            ++authenticationRequestExtraParamsListIndex;
                        }
                    }
                    if (authenticateOidcConfig.onUnauthenticatedRequestAsString() != null) {
                        request.addParameter("Actions.member." + actionsListIndex + ".AuthenticateOidcConfig.OnUnauthenticatedRequest", StringConversion.fromString((String)authenticateOidcConfig.onUnauthenticatedRequestAsString()));
                    }
                }
                if ((authenticateCognitoConfig = actionsListValue.authenticateCognitoConfig()) != null) {
                    Map<String, String> authenticationRequestExtraParams;
                    if (authenticateCognitoConfig.userPoolArn() != null) {
                        request.addParameter("Actions.member." + actionsListIndex + ".AuthenticateCognitoConfig.UserPoolArn", StringConversion.fromString((String)authenticateCognitoConfig.userPoolArn()));
                    }
                    if (authenticateCognitoConfig.userPoolClientId() != null) {
                        request.addParameter("Actions.member." + actionsListIndex + ".AuthenticateCognitoConfig.UserPoolClientId", StringConversion.fromString((String)authenticateCognitoConfig.userPoolClientId()));
                    }
                    if (authenticateCognitoConfig.userPoolDomain() != null) {
                        request.addParameter("Actions.member." + actionsListIndex + ".AuthenticateCognitoConfig.UserPoolDomain", StringConversion.fromString((String)authenticateCognitoConfig.userPoolDomain()));
                    }
                    if (authenticateCognitoConfig.sessionCookieName() != null) {
                        request.addParameter("Actions.member." + actionsListIndex + ".AuthenticateCognitoConfig.SessionCookieName", StringConversion.fromString((String)authenticateCognitoConfig.sessionCookieName()));
                    }
                    if (authenticateCognitoConfig.scope() != null) {
                        request.addParameter("Actions.member." + actionsListIndex + ".AuthenticateCognitoConfig.Scope", StringConversion.fromString((String)authenticateCognitoConfig.scope()));
                    }
                    if (authenticateCognitoConfig.sessionTimeout() != null) {
                        request.addParameter("Actions.member." + actionsListIndex + ".AuthenticateCognitoConfig.SessionTimeout", StringConversion.fromLong((Long)authenticateCognitoConfig.sessionTimeout()));
                    }
                    if ((authenticationRequestExtraParams = authenticateCognitoConfig.authenticationRequestExtraParams()) != null) {
                        boolean bl = true;
                        for (Map.Entry<String, String> entry : authenticationRequestExtraParams.entrySet()) {
                            void var10_19;
                            if (entry.getKey() != null) {
                                request.addParameter("Actions.member." + actionsListIndex + ".AuthenticateCognitoConfig.AuthenticationRequestExtraParams.entry." + (int)var10_19 + ".key", StringConversion.fromString((String)entry.getKey()));
                            }
                            if (entry.getValue() != null) {
                                request.addParameter("Actions.member." + actionsListIndex + ".AuthenticateCognitoConfig.AuthenticationRequestExtraParams.entry." + (int)var10_19 + ".value", StringConversion.fromString((String)entry.getValue()));
                            }
                            ++var10_19;
                        }
                    }
                    if (authenticateCognitoConfig.onUnauthenticatedRequestAsString() != null) {
                        request.addParameter("Actions.member." + actionsListIndex + ".AuthenticateCognitoConfig.OnUnauthenticatedRequest", StringConversion.fromString((String)authenticateCognitoConfig.onUnauthenticatedRequestAsString()));
                    }
                }
                if (actionsListValue.order() != null) {
                    request.addParameter("Actions.member." + actionsListIndex + ".Order", StringConversion.fromInteger((Integer)actionsListValue.order()));
                }
                if ((redirectConfig = actionsListValue.redirectConfig()) != null) {
                    if (redirectConfig.protocol() != null) {
                        request.addParameter("Actions.member." + actionsListIndex + ".RedirectConfig.Protocol", StringConversion.fromString((String)redirectConfig.protocol()));
                    }
                    if (redirectConfig.port() != null) {
                        request.addParameter("Actions.member." + actionsListIndex + ".RedirectConfig.Port", StringConversion.fromString((String)redirectConfig.port()));
                    }
                    if (redirectConfig.host() != null) {
                        request.addParameter("Actions.member." + actionsListIndex + ".RedirectConfig.Host", StringConversion.fromString((String)redirectConfig.host()));
                    }
                    if (redirectConfig.path() != null) {
                        request.addParameter("Actions.member." + actionsListIndex + ".RedirectConfig.Path", StringConversion.fromString((String)redirectConfig.path()));
                    }
                    if (redirectConfig.query() != null) {
                        request.addParameter("Actions.member." + actionsListIndex + ".RedirectConfig.Query", StringConversion.fromString((String)redirectConfig.query()));
                    }
                    if (redirectConfig.statusCodeAsString() != null) {
                        request.addParameter("Actions.member." + actionsListIndex + ".RedirectConfig.StatusCode", StringConversion.fromString((String)redirectConfig.statusCodeAsString()));
                    }
                }
                if ((fixedResponseActionConfig = actionsListValue.fixedResponseConfig()) != null) {
                    if (fixedResponseActionConfig.messageBody() != null) {
                        request.addParameter("Actions.member." + actionsListIndex + ".FixedResponseConfig.MessageBody", StringConversion.fromString((String)fixedResponseActionConfig.messageBody()));
                    }
                    if (fixedResponseActionConfig.statusCode() != null) {
                        request.addParameter("Actions.member." + actionsListIndex + ".FixedResponseConfig.StatusCode", StringConversion.fromString((String)fixedResponseActionConfig.statusCode()));
                    }
                    if (fixedResponseActionConfig.contentType() != null) {
                        request.addParameter("Actions.member." + actionsListIndex + ".FixedResponseConfig.ContentType", StringConversion.fromString((String)fixedResponseActionConfig.contentType()));
                    }
                }
                ++actionsListIndex;
            }
        }
        return request;
    }
}

