/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticloadbalancingv2.transform;

import java.util.List;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.Certificate;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.RemoveListenerCertificatesRequest;

public class RemoveListenerCertificatesRequestMarshaller
implements Marshaller<Request<RemoveListenerCertificatesRequest>, RemoveListenerCertificatesRequest> {
    public Request<RemoveListenerCertificatesRequest> marshall(RemoveListenerCertificatesRequest removeListenerCertificatesRequest) {
        if (removeListenerCertificatesRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)removeListenerCertificatesRequest, "ElasticLoadBalancingV2Client");
        request.addParameter("Action", "RemoveListenerCertificates");
        request.addParameter("Version", "2015-12-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (removeListenerCertificatesRequest.listenerArn() != null) {
            request.addParameter("ListenerArn", StringConversion.fromString((String)removeListenerCertificatesRequest.listenerArn()));
        }
        if (removeListenerCertificatesRequest.certificates().isEmpty() && !(removeListenerCertificatesRequest.certificates() instanceof SdkAutoConstructList)) {
            request.addParameter("Certificates", "");
        } else if (!removeListenerCertificatesRequest.certificates().isEmpty() && !(removeListenerCertificatesRequest.certificates() instanceof SdkAutoConstructList)) {
            List<Certificate> certificatesList = removeListenerCertificatesRequest.certificates();
            int certificatesListIndex = 1;
            for (Certificate certificatesListValue : certificatesList) {
                if (certificatesListValue.certificateArn() != null) {
                    request.addParameter("Certificates.member." + certificatesListIndex + ".CertificateArn", StringConversion.fromString((String)certificatesListValue.certificateArn()));
                }
                if (certificatesListValue.isDefault() != null) {
                    request.addParameter("Certificates.member." + certificatesListIndex + ".IsDefault", StringConversion.fromBoolean((Boolean)certificatesListValue.isDefault()));
                }
                ++certificatesListIndex;
            }
        }
        return request;
    }
}

