/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticloadbalancingv2.transform;

import java.util.List;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeTargetGroupsRequest;

public class DescribeTargetGroupsRequestMarshaller
implements Marshaller<Request<DescribeTargetGroupsRequest>, DescribeTargetGroupsRequest> {
    public Request<DescribeTargetGroupsRequest> marshall(DescribeTargetGroupsRequest describeTargetGroupsRequest) {
        if (describeTargetGroupsRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)describeTargetGroupsRequest, "ElasticLoadBalancingV2Client");
        request.addParameter("Action", "DescribeTargetGroups");
        request.addParameter("Version", "2015-12-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (describeTargetGroupsRequest.loadBalancerArn() != null) {
            request.addParameter("LoadBalancerArn", StringConversion.fromString((String)describeTargetGroupsRequest.loadBalancerArn()));
        }
        if (describeTargetGroupsRequest.targetGroupArns().isEmpty() && !(describeTargetGroupsRequest.targetGroupArns() instanceof SdkAutoConstructList)) {
            request.addParameter("TargetGroupArns", "");
        } else if (!describeTargetGroupsRequest.targetGroupArns().isEmpty() && !(describeTargetGroupsRequest.targetGroupArns() instanceof SdkAutoConstructList)) {
            List<String> targetGroupArnsList = describeTargetGroupsRequest.targetGroupArns();
            int targetGroupArnsListIndex = 1;
            for (String targetGroupArnsListValue : targetGroupArnsList) {
                if (targetGroupArnsListValue != null) {
                    request.addParameter("TargetGroupArns.member." + targetGroupArnsListIndex, StringConversion.fromString((String)targetGroupArnsListValue));
                }
                ++targetGroupArnsListIndex;
            }
        }
        if (describeTargetGroupsRequest.names().isEmpty() && !(describeTargetGroupsRequest.names() instanceof SdkAutoConstructList)) {
            request.addParameter("Names", "");
        } else if (!describeTargetGroupsRequest.names().isEmpty() && !(describeTargetGroupsRequest.names() instanceof SdkAutoConstructList)) {
            List<String> namesList = describeTargetGroupsRequest.names();
            int namesListIndex = 1;
            for (String namesListValue : namesList) {
                if (namesListValue != null) {
                    request.addParameter("Names.member." + namesListIndex, StringConversion.fromString((String)namesListValue));
                }
                ++namesListIndex;
            }
        }
        if (describeTargetGroupsRequest.marker() != null) {
            request.addParameter("Marker", StringConversion.fromString((String)describeTargetGroupsRequest.marker()));
        }
        if (describeTargetGroupsRequest.pageSize() != null) {
            request.addParameter("PageSize", StringConversion.fromInteger((Integer)describeTargetGroupsRequest.pageSize()));
        }
        return request;
    }
}

