/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticloadbalancingv2.transform;

import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringUtils;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.CreateTargetGroupRequest;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.Matcher;

public class CreateTargetGroupRequestMarshaller
implements Marshaller<Request<CreateTargetGroupRequest>, CreateTargetGroupRequest> {
    public Request<CreateTargetGroupRequest> marshall(CreateTargetGroupRequest createTargetGroupRequest) {
        Matcher matcher;
        if (createTargetGroupRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((Object)createTargetGroupRequest, "ElasticLoadBalancingv2Client");
        request.addParameter("Action", "CreateTargetGroup");
        request.addParameter("Version", "2015-12-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (createTargetGroupRequest.name() != null) {
            request.addParameter("Name", StringUtils.fromString((String)createTargetGroupRequest.name()));
        }
        if (createTargetGroupRequest.protocolAsString() != null) {
            request.addParameter("Protocol", StringUtils.fromString((String)createTargetGroupRequest.protocolAsString()));
        }
        if (createTargetGroupRequest.port() != null) {
            request.addParameter("Port", StringUtils.fromInteger((Integer)createTargetGroupRequest.port()));
        }
        if (createTargetGroupRequest.vpcId() != null) {
            request.addParameter("VpcId", StringUtils.fromString((String)createTargetGroupRequest.vpcId()));
        }
        if (createTargetGroupRequest.healthCheckProtocolAsString() != null) {
            request.addParameter("HealthCheckProtocol", StringUtils.fromString((String)createTargetGroupRequest.healthCheckProtocolAsString()));
        }
        if (createTargetGroupRequest.healthCheckPort() != null) {
            request.addParameter("HealthCheckPort", StringUtils.fromString((String)createTargetGroupRequest.healthCheckPort()));
        }
        if (createTargetGroupRequest.healthCheckPath() != null) {
            request.addParameter("HealthCheckPath", StringUtils.fromString((String)createTargetGroupRequest.healthCheckPath()));
        }
        if (createTargetGroupRequest.healthCheckIntervalSeconds() != null) {
            request.addParameter("HealthCheckIntervalSeconds", StringUtils.fromInteger((Integer)createTargetGroupRequest.healthCheckIntervalSeconds()));
        }
        if (createTargetGroupRequest.healthCheckTimeoutSeconds() != null) {
            request.addParameter("HealthCheckTimeoutSeconds", StringUtils.fromInteger((Integer)createTargetGroupRequest.healthCheckTimeoutSeconds()));
        }
        if (createTargetGroupRequest.healthyThresholdCount() != null) {
            request.addParameter("HealthyThresholdCount", StringUtils.fromInteger((Integer)createTargetGroupRequest.healthyThresholdCount()));
        }
        if (createTargetGroupRequest.unhealthyThresholdCount() != null) {
            request.addParameter("UnhealthyThresholdCount", StringUtils.fromInteger((Integer)createTargetGroupRequest.unhealthyThresholdCount()));
        }
        if ((matcher = createTargetGroupRequest.matcher()) != null && matcher.httpCode() != null) {
            request.addParameter("Matcher.HttpCode", StringUtils.fromString((String)matcher.httpCode()));
        }
        if (createTargetGroupRequest.targetTypeAsString() != null) {
            request.addParameter("TargetType", StringUtils.fromString((String)createTargetGroupRequest.targetTypeAsString()));
        }
        return request;
    }
}

