/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticloadbalancingv2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.LoadBalancerArnsCopier;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.Matcher;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.ProtocolEnum;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.TargetTypeEnum;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class TargetGroup
implements ToCopyableBuilder<Builder, TargetGroup> {
    private final String targetGroupArn;
    private final String targetGroupName;
    private final String protocol;
    private final Integer port;
    private final String vpcId;
    private final String healthCheckProtocol;
    private final String healthCheckPort;
    private final Integer healthCheckIntervalSeconds;
    private final Integer healthCheckTimeoutSeconds;
    private final Integer healthyThresholdCount;
    private final Integer unhealthyThresholdCount;
    private final String healthCheckPath;
    private final Matcher matcher;
    private final List<String> loadBalancerArns;
    private final String targetType;

    private TargetGroup(BuilderImpl builder) {
        this.targetGroupArn = builder.targetGroupArn;
        this.targetGroupName = builder.targetGroupName;
        this.protocol = builder.protocol;
        this.port = builder.port;
        this.vpcId = builder.vpcId;
        this.healthCheckProtocol = builder.healthCheckProtocol;
        this.healthCheckPort = builder.healthCheckPort;
        this.healthCheckIntervalSeconds = builder.healthCheckIntervalSeconds;
        this.healthCheckTimeoutSeconds = builder.healthCheckTimeoutSeconds;
        this.healthyThresholdCount = builder.healthyThresholdCount;
        this.unhealthyThresholdCount = builder.unhealthyThresholdCount;
        this.healthCheckPath = builder.healthCheckPath;
        this.matcher = builder.matcher;
        this.loadBalancerArns = builder.loadBalancerArns;
        this.targetType = builder.targetType;
    }

    public String targetGroupArn() {
        return this.targetGroupArn;
    }

    public String targetGroupName() {
        return this.targetGroupName;
    }

    public ProtocolEnum protocol() {
        return ProtocolEnum.fromValue(this.protocol);
    }

    public String protocolAsString() {
        return this.protocol;
    }

    public Integer port() {
        return this.port;
    }

    public String vpcId() {
        return this.vpcId;
    }

    public ProtocolEnum healthCheckProtocol() {
        return ProtocolEnum.fromValue(this.healthCheckProtocol);
    }

    public String healthCheckProtocolAsString() {
        return this.healthCheckProtocol;
    }

    public String healthCheckPort() {
        return this.healthCheckPort;
    }

    public Integer healthCheckIntervalSeconds() {
        return this.healthCheckIntervalSeconds;
    }

    public Integer healthCheckTimeoutSeconds() {
        return this.healthCheckTimeoutSeconds;
    }

    public Integer healthyThresholdCount() {
        return this.healthyThresholdCount;
    }

    public Integer unhealthyThresholdCount() {
        return this.unhealthyThresholdCount;
    }

    public String healthCheckPath() {
        return this.healthCheckPath;
    }

    public Matcher matcher() {
        return this.matcher;
    }

    public List<String> loadBalancerArns() {
        return this.loadBalancerArns;
    }

    public TargetTypeEnum targetType() {
        return TargetTypeEnum.fromValue(this.targetType);
    }

    public String targetTypeAsString() {
        return this.targetType;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.targetGroupArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.targetGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(this.protocolAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.port());
        hashCode = 31 * hashCode + Objects.hashCode(this.vpcId());
        hashCode = 31 * hashCode + Objects.hashCode(this.healthCheckProtocolAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.healthCheckPort());
        hashCode = 31 * hashCode + Objects.hashCode(this.healthCheckIntervalSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(this.healthCheckTimeoutSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(this.healthyThresholdCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.unhealthyThresholdCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.healthCheckPath());
        hashCode = 31 * hashCode + Objects.hashCode(this.matcher());
        hashCode = 31 * hashCode + Objects.hashCode(this.loadBalancerArns());
        hashCode = 31 * hashCode + Objects.hashCode(this.targetTypeAsString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TargetGroup)) {
            return false;
        }
        TargetGroup other = (TargetGroup)obj;
        return Objects.equals(this.targetGroupArn(), other.targetGroupArn()) && Objects.equals(this.targetGroupName(), other.targetGroupName()) && Objects.equals(this.protocolAsString(), other.protocolAsString()) && Objects.equals(this.port(), other.port()) && Objects.equals(this.vpcId(), other.vpcId()) && Objects.equals(this.healthCheckProtocolAsString(), other.healthCheckProtocolAsString()) && Objects.equals(this.healthCheckPort(), other.healthCheckPort()) && Objects.equals(this.healthCheckIntervalSeconds(), other.healthCheckIntervalSeconds()) && Objects.equals(this.healthCheckTimeoutSeconds(), other.healthCheckTimeoutSeconds()) && Objects.equals(this.healthyThresholdCount(), other.healthyThresholdCount()) && Objects.equals(this.unhealthyThresholdCount(), other.unhealthyThresholdCount()) && Objects.equals(this.healthCheckPath(), other.healthCheckPath()) && Objects.equals(this.matcher(), other.matcher()) && Objects.equals(this.loadBalancerArns(), other.loadBalancerArns()) && Objects.equals(this.targetTypeAsString(), other.targetTypeAsString());
    }

    public String toString() {
        return ToString.builder((String)"TargetGroup").add("TargetGroupArn", (Object)this.targetGroupArn()).add("TargetGroupName", (Object)this.targetGroupName()).add("Protocol", (Object)this.protocolAsString()).add("Port", (Object)this.port()).add("VpcId", (Object)this.vpcId()).add("HealthCheckProtocol", (Object)this.healthCheckProtocolAsString()).add("HealthCheckPort", (Object)this.healthCheckPort()).add("HealthCheckIntervalSeconds", (Object)this.healthCheckIntervalSeconds()).add("HealthCheckTimeoutSeconds", (Object)this.healthCheckTimeoutSeconds()).add("HealthyThresholdCount", (Object)this.healthyThresholdCount()).add("UnhealthyThresholdCount", (Object)this.unhealthyThresholdCount()).add("HealthCheckPath", (Object)this.healthCheckPath()).add("Matcher", (Object)this.matcher()).add("LoadBalancerArns", this.loadBalancerArns()).add("TargetType", (Object)this.targetTypeAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TargetGroupArn": {
                return Optional.of(clazz.cast(this.targetGroupArn()));
            }
            case "TargetGroupName": {
                return Optional.of(clazz.cast(this.targetGroupName()));
            }
            case "Protocol": {
                return Optional.of(clazz.cast(this.protocolAsString()));
            }
            case "Port": {
                return Optional.of(clazz.cast(this.port()));
            }
            case "VpcId": {
                return Optional.of(clazz.cast(this.vpcId()));
            }
            case "HealthCheckProtocol": {
                return Optional.of(clazz.cast(this.healthCheckProtocolAsString()));
            }
            case "HealthCheckPort": {
                return Optional.of(clazz.cast(this.healthCheckPort()));
            }
            case "HealthCheckIntervalSeconds": {
                return Optional.of(clazz.cast(this.healthCheckIntervalSeconds()));
            }
            case "HealthCheckTimeoutSeconds": {
                return Optional.of(clazz.cast(this.healthCheckTimeoutSeconds()));
            }
            case "HealthyThresholdCount": {
                return Optional.of(clazz.cast(this.healthyThresholdCount()));
            }
            case "UnhealthyThresholdCount": {
                return Optional.of(clazz.cast(this.unhealthyThresholdCount()));
            }
            case "HealthCheckPath": {
                return Optional.of(clazz.cast(this.healthCheckPath()));
            }
            case "Matcher": {
                return Optional.of(clazz.cast(this.matcher()));
            }
            case "LoadBalancerArns": {
                return Optional.of(clazz.cast(this.loadBalancerArns()));
            }
            case "TargetType": {
                return Optional.of(clazz.cast(this.targetTypeAsString()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String targetGroupArn;
        private String targetGroupName;
        private String protocol;
        private Integer port;
        private String vpcId;
        private String healthCheckProtocol;
        private String healthCheckPort;
        private Integer healthCheckIntervalSeconds;
        private Integer healthCheckTimeoutSeconds;
        private Integer healthyThresholdCount;
        private Integer unhealthyThresholdCount;
        private String healthCheckPath;
        private Matcher matcher;
        private List<String> loadBalancerArns;
        private String targetType;

        private BuilderImpl() {
        }

        private BuilderImpl(TargetGroup model) {
            this.targetGroupArn(model.targetGroupArn);
            this.targetGroupName(model.targetGroupName);
            this.protocol(model.protocol);
            this.port(model.port);
            this.vpcId(model.vpcId);
            this.healthCheckProtocol(model.healthCheckProtocol);
            this.healthCheckPort(model.healthCheckPort);
            this.healthCheckIntervalSeconds(model.healthCheckIntervalSeconds);
            this.healthCheckTimeoutSeconds(model.healthCheckTimeoutSeconds);
            this.healthyThresholdCount(model.healthyThresholdCount);
            this.unhealthyThresholdCount(model.unhealthyThresholdCount);
            this.healthCheckPath(model.healthCheckPath);
            this.matcher(model.matcher);
            this.loadBalancerArns(model.loadBalancerArns);
            this.targetType(model.targetType);
        }

        public final String getTargetGroupArn() {
            return this.targetGroupArn;
        }

        @Override
        public final Builder targetGroupArn(String targetGroupArn) {
            this.targetGroupArn = targetGroupArn;
            return this;
        }

        public final void setTargetGroupArn(String targetGroupArn) {
            this.targetGroupArn = targetGroupArn;
        }

        public final String getTargetGroupName() {
            return this.targetGroupName;
        }

        @Override
        public final Builder targetGroupName(String targetGroupName) {
            this.targetGroupName = targetGroupName;
            return this;
        }

        public final void setTargetGroupName(String targetGroupName) {
            this.targetGroupName = targetGroupName;
        }

        public final String getProtocol() {
            return this.protocol;
        }

        @Override
        public final Builder protocol(String protocol) {
            this.protocol = protocol;
            return this;
        }

        @Override
        public final Builder protocol(ProtocolEnum protocol) {
            this.protocol(protocol.toString());
            return this;
        }

        public final void setProtocol(String protocol) {
            this.protocol = protocol;
        }

        public final Integer getPort() {
            return this.port;
        }

        @Override
        public final Builder port(Integer port) {
            this.port = port;
            return this;
        }

        public final void setPort(Integer port) {
            this.port = port;
        }

        public final String getVpcId() {
            return this.vpcId;
        }

        @Override
        public final Builder vpcId(String vpcId) {
            this.vpcId = vpcId;
            return this;
        }

        public final void setVpcId(String vpcId) {
            this.vpcId = vpcId;
        }

        public final String getHealthCheckProtocol() {
            return this.healthCheckProtocol;
        }

        @Override
        public final Builder healthCheckProtocol(String healthCheckProtocol) {
            this.healthCheckProtocol = healthCheckProtocol;
            return this;
        }

        @Override
        public final Builder healthCheckProtocol(ProtocolEnum healthCheckProtocol) {
            this.healthCheckProtocol(healthCheckProtocol.toString());
            return this;
        }

        public final void setHealthCheckProtocol(String healthCheckProtocol) {
            this.healthCheckProtocol = healthCheckProtocol;
        }

        public final String getHealthCheckPort() {
            return this.healthCheckPort;
        }

        @Override
        public final Builder healthCheckPort(String healthCheckPort) {
            this.healthCheckPort = healthCheckPort;
            return this;
        }

        public final void setHealthCheckPort(String healthCheckPort) {
            this.healthCheckPort = healthCheckPort;
        }

        public final Integer getHealthCheckIntervalSeconds() {
            return this.healthCheckIntervalSeconds;
        }

        @Override
        public final Builder healthCheckIntervalSeconds(Integer healthCheckIntervalSeconds) {
            this.healthCheckIntervalSeconds = healthCheckIntervalSeconds;
            return this;
        }

        public final void setHealthCheckIntervalSeconds(Integer healthCheckIntervalSeconds) {
            this.healthCheckIntervalSeconds = healthCheckIntervalSeconds;
        }

        public final Integer getHealthCheckTimeoutSeconds() {
            return this.healthCheckTimeoutSeconds;
        }

        @Override
        public final Builder healthCheckTimeoutSeconds(Integer healthCheckTimeoutSeconds) {
            this.healthCheckTimeoutSeconds = healthCheckTimeoutSeconds;
            return this;
        }

        public final void setHealthCheckTimeoutSeconds(Integer healthCheckTimeoutSeconds) {
            this.healthCheckTimeoutSeconds = healthCheckTimeoutSeconds;
        }

        public final Integer getHealthyThresholdCount() {
            return this.healthyThresholdCount;
        }

        @Override
        public final Builder healthyThresholdCount(Integer healthyThresholdCount) {
            this.healthyThresholdCount = healthyThresholdCount;
            return this;
        }

        public final void setHealthyThresholdCount(Integer healthyThresholdCount) {
            this.healthyThresholdCount = healthyThresholdCount;
        }

        public final Integer getUnhealthyThresholdCount() {
            return this.unhealthyThresholdCount;
        }

        @Override
        public final Builder unhealthyThresholdCount(Integer unhealthyThresholdCount) {
            this.unhealthyThresholdCount = unhealthyThresholdCount;
            return this;
        }

        public final void setUnhealthyThresholdCount(Integer unhealthyThresholdCount) {
            this.unhealthyThresholdCount = unhealthyThresholdCount;
        }

        public final String getHealthCheckPath() {
            return this.healthCheckPath;
        }

        @Override
        public final Builder healthCheckPath(String healthCheckPath) {
            this.healthCheckPath = healthCheckPath;
            return this;
        }

        public final void setHealthCheckPath(String healthCheckPath) {
            this.healthCheckPath = healthCheckPath;
        }

        public final Matcher.Builder getMatcher() {
            return this.matcher != null ? this.matcher.toBuilder() : null;
        }

        @Override
        public final Builder matcher(Matcher matcher) {
            this.matcher = matcher;
            return this;
        }

        public final void setMatcher(Matcher.BuilderImpl matcher) {
            this.matcher = matcher != null ? matcher.build() : null;
        }

        public final Collection<String> getLoadBalancerArns() {
            return this.loadBalancerArns;
        }

        @Override
        public final Builder loadBalancerArns(Collection<String> loadBalancerArns) {
            this.loadBalancerArns = LoadBalancerArnsCopier.copy(loadBalancerArns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder loadBalancerArns(String ... loadBalancerArns) {
            this.loadBalancerArns(Arrays.asList(loadBalancerArns));
            return this;
        }

        public final void setLoadBalancerArns(Collection<String> loadBalancerArns) {
            this.loadBalancerArns = LoadBalancerArnsCopier.copy(loadBalancerArns);
        }

        public final String getTargetType() {
            return this.targetType;
        }

        @Override
        public final Builder targetType(String targetType) {
            this.targetType = targetType;
            return this;
        }

        @Override
        public final Builder targetType(TargetTypeEnum targetType) {
            this.targetType(targetType.toString());
            return this;
        }

        public final void setTargetType(String targetType) {
            this.targetType = targetType;
        }

        public TargetGroup build() {
            return new TargetGroup(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, TargetGroup> {
        public Builder targetGroupArn(String var1);

        public Builder targetGroupName(String var1);

        public Builder protocol(String var1);

        public Builder protocol(ProtocolEnum var1);

        public Builder port(Integer var1);

        public Builder vpcId(String var1);

        public Builder healthCheckProtocol(String var1);

        public Builder healthCheckProtocol(ProtocolEnum var1);

        public Builder healthCheckPort(String var1);

        public Builder healthCheckIntervalSeconds(Integer var1);

        public Builder healthCheckTimeoutSeconds(Integer var1);

        public Builder healthyThresholdCount(Integer var1);

        public Builder unhealthyThresholdCount(Integer var1);

        public Builder healthCheckPath(String var1);

        public Builder matcher(Matcher var1);

        default public Builder matcher(Consumer<Matcher.Builder> matcher) {
            return this.matcher((Matcher)((Matcher.Builder)Matcher.builder().apply(matcher)).build());
        }

        public Builder loadBalancerArns(Collection<String> var1);

        public Builder loadBalancerArns(String ... var1);

        public Builder targetType(String var1);

        public Builder targetType(TargetTypeEnum var1);
    }
}

