/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticloadbalancingv2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.ElasticLoadBalancingv2Response;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.TargetGroup;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.TargetGroupsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeTargetGroupsResponse
extends ElasticLoadBalancingv2Response
implements ToCopyableBuilder<Builder, DescribeTargetGroupsResponse> {
    private final List<TargetGroup> targetGroups;
    private final String nextMarker;

    private DescribeTargetGroupsResponse(BuilderImpl builder) {
        super(builder);
        this.targetGroups = builder.targetGroups;
        this.nextMarker = builder.nextMarker;
    }

    public List<TargetGroup> targetGroups() {
        return this.targetGroups;
    }

    public String nextMarker() {
        return this.nextMarker;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.targetGroups());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextMarker());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeTargetGroupsResponse)) {
            return false;
        }
        DescribeTargetGroupsResponse other = (DescribeTargetGroupsResponse)((Object)obj);
        return Objects.equals(this.targetGroups(), other.targetGroups()) && Objects.equals(this.nextMarker(), other.nextMarker());
    }

    public String toString() {
        return ToString.builder((String)"DescribeTargetGroupsResponse").add("TargetGroups", this.targetGroups()).add("NextMarker", (Object)this.nextMarker()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TargetGroups": {
                return Optional.of(clazz.cast(this.targetGroups()));
            }
            case "NextMarker": {
                return Optional.of(clazz.cast(this.nextMarker()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends ElasticLoadBalancingv2Response.BuilderImpl
    implements Builder {
        private List<TargetGroup> targetGroups;
        private String nextMarker;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeTargetGroupsResponse model) {
            super(model);
            this.targetGroups(model.targetGroups);
            this.nextMarker(model.nextMarker);
        }

        public final Collection<TargetGroup.Builder> getTargetGroups() {
            return this.targetGroups != null ? (Collection)this.targetGroups.stream().map(TargetGroup::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder targetGroups(Collection<TargetGroup> targetGroups) {
            this.targetGroups = TargetGroupsCopier.copy(targetGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder targetGroups(TargetGroup ... targetGroups) {
            this.targetGroups(Arrays.asList(targetGroups));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder targetGroups(Consumer<TargetGroup.Builder> ... targetGroups) {
            this.targetGroups(Stream.of(targetGroups).map(c -> (TargetGroup)((TargetGroup.Builder)TargetGroup.builder().apply((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTargetGroups(Collection<TargetGroup.BuilderImpl> targetGroups) {
            this.targetGroups = TargetGroupsCopier.copyFromBuilder(targetGroups);
        }

        public final String getNextMarker() {
            return this.nextMarker;
        }

        @Override
        public final Builder nextMarker(String nextMarker) {
            this.nextMarker = nextMarker;
            return this;
        }

        public final void setNextMarker(String nextMarker) {
            this.nextMarker = nextMarker;
        }

        @Override
        public DescribeTargetGroupsResponse build() {
            return new DescribeTargetGroupsResponse(this);
        }
    }

    public static interface Builder
    extends ElasticLoadBalancingv2Response.Builder,
    CopyableBuilder<Builder, DescribeTargetGroupsResponse> {
        public Builder targetGroups(Collection<TargetGroup> var1);

        public Builder targetGroups(TargetGroup ... var1);

        public Builder targetGroups(Consumer<TargetGroup.Builder> ... var1);

        public Builder nextMarker(String var1);
    }
}

