/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticloadbalancingv2.transform;

import java.util.ArrayList;
import javax.xml.stream.events.XMLEvent;
import software.amazon.awssdk.runtime.transform.SimpleTypeStaxUnmarshallers;
import software.amazon.awssdk.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.TargetGroup;
import software.amazon.awssdk.services.elasticloadbalancingv2.transform.MatcherUnmarshaller;

public class TargetGroupUnmarshaller
implements Unmarshaller<TargetGroup, StaxUnmarshallerContext> {
    private static TargetGroupUnmarshaller INSTANCE;

    public TargetGroup unmarshall(StaxUnmarshallerContext context) throws Exception {
        XMLEvent xmlEvent;
        TargetGroup.Builder targetGroup = TargetGroup.builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (!(xmlEvent = context.nextEvent()).isEndDocument()) {
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("TargetGroupArn", targetDepth)) {
                    targetGroup.targetGroupArn(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("TargetGroupName", targetDepth)) {
                    targetGroup.targetGroupName(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("Protocol", targetDepth)) {
                    targetGroup.protocol(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("Port", targetDepth)) {
                    targetGroup.port(SimpleTypeStaxUnmarshallers.IntegerUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("VpcId", targetDepth)) {
                    targetGroup.vpcId(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("HealthCheckProtocol", targetDepth)) {
                    targetGroup.healthCheckProtocol(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("HealthCheckPort", targetDepth)) {
                    targetGroup.healthCheckPort(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("HealthCheckIntervalSeconds", targetDepth)) {
                    targetGroup.healthCheckIntervalSeconds(SimpleTypeStaxUnmarshallers.IntegerUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("HealthCheckTimeoutSeconds", targetDepth)) {
                    targetGroup.healthCheckTimeoutSeconds(SimpleTypeStaxUnmarshallers.IntegerUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("HealthyThresholdCount", targetDepth)) {
                    targetGroup.healthyThresholdCount(SimpleTypeStaxUnmarshallers.IntegerUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("UnhealthyThresholdCount", targetDepth)) {
                    targetGroup.unhealthyThresholdCount(SimpleTypeStaxUnmarshallers.IntegerUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("HealthCheckPath", targetDepth)) {
                    targetGroup.healthCheckPath(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("Matcher", targetDepth)) {
                    targetGroup.matcher(MatcherUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("LoadBalancerArns", targetDepth)) {
                    targetGroup.loadBalancerArns(new ArrayList<String>());
                    continue;
                }
                if (!context.testExpression("LoadBalancerArns/member", targetDepth)) continue;
                targetGroup.loadBalancerArns(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (!xmlEvent.isEndElement() || context.getCurrentDepth() >= originalDepth) continue;
            break;
        }
        return (TargetGroup)targetGroup.build();
    }

    public static TargetGroupUnmarshaller getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new TargetGroupUnmarshaller();
        }
        return INSTANCE;
    }
}

