/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticloadbalancingv2.transform;

import java.util.ArrayList;
import javax.xml.stream.events.XMLEvent;
import software.amazon.awssdk.runtime.transform.SimpleTypeStaxUnmarshallers;
import software.amazon.awssdk.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.Cipher;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.SslPolicy;
import software.amazon.awssdk.services.elasticloadbalancingv2.transform.CipherUnmarshaller;

public class SslPolicyUnmarshaller
implements Unmarshaller<SslPolicy, StaxUnmarshallerContext> {
    private static SslPolicyUnmarshaller INSTANCE;

    public SslPolicy unmarshall(StaxUnmarshallerContext context) throws Exception {
        XMLEvent xmlEvent;
        SslPolicy.Builder sslPolicy = SslPolicy.builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (!(xmlEvent = context.nextEvent()).isEndDocument()) {
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("SslProtocols", targetDepth)) {
                    sslPolicy.sslProtocols(new ArrayList<String>());
                    continue;
                }
                if (context.testExpression("SslProtocols/member", targetDepth)) {
                    sslPolicy.sslProtocols(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("Ciphers", targetDepth)) {
                    sslPolicy.ciphers(new ArrayList<Cipher>());
                    continue;
                }
                if (context.testExpression("Ciphers/member", targetDepth)) {
                    sslPolicy.ciphers(CipherUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("Name", targetDepth)) continue;
                sslPolicy.name(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (!xmlEvent.isEndElement() || context.getCurrentDepth() >= originalDepth) continue;
            break;
        }
        return (SslPolicy)sslPolicy.build();
    }

    public static SslPolicyUnmarshaller getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new SslPolicyUnmarshaller();
        }
        return INSTANCE;
    }
}

