/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticloadbalancingv2.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.Listener;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.ListenersCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ModifyListenerResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, ModifyListenerResponse> {
    private final List<Listener> listeners;

    private ModifyListenerResponse(BuilderImpl builder) {
        this.listeners = builder.listeners;
    }

    public List<Listener> listeners() {
        return this.listeners;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.listeners() == null ? 0 : this.listeners().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModifyListenerResponse)) {
            return false;
        }
        ModifyListenerResponse other = (ModifyListenerResponse)((Object)obj);
        if (other.listeners() == null ^ this.listeners() == null) {
            return false;
        }
        return other.listeners() == null || other.listeners().equals(this.listeners());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.listeners() != null) {
            sb.append("Listeners: ").append(this.listeners()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private List<Listener> listeners;

        private BuilderImpl() {
        }

        private BuilderImpl(ModifyListenerResponse model) {
            this.setListeners(model.listeners);
        }

        public final Collection<Listener> getListeners() {
            return this.listeners;
        }

        @Override
        public final Builder listeners(Collection<Listener> listeners) {
            this.listeners = ListenersCopier.copy(listeners);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder listeners(Listener ... listeners) {
            if (this.listeners == null) {
                this.listeners = new ArrayList<Listener>(listeners.length);
            }
            for (Listener e : listeners) {
                this.listeners.add(e);
            }
            return this;
        }

        public final void setListeners(Collection<Listener> listeners) {
            this.listeners = ListenersCopier.copy(listeners);
        }

        @SafeVarargs
        public final void setListeners(Listener ... listeners) {
            if (this.listeners == null) {
                this.listeners = new ArrayList<Listener>(listeners.length);
            }
            for (Listener e : listeners) {
                this.listeners.add(e);
            }
        }

        public ModifyListenerResponse build() {
            return new ModifyListenerResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ModifyListenerResponse> {
        public Builder listeners(Collection<Listener> var1);

        public Builder listeners(Listener ... var1);
    }
}

