/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticloadbalancing.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.elasticloadbalancing.model.ElasticLoadBalancingResponse;
import software.amazon.awssdk.services.elasticloadbalancing.model.InstanceState;
import software.amazon.awssdk.services.elasticloadbalancing.model.InstanceStatesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeInstanceHealthResponse
extends ElasticLoadBalancingResponse
implements ToCopyableBuilder<Builder, DescribeInstanceHealthResponse> {
    private static final SdkField<List<InstanceState>> INSTANCE_STATES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(DescribeInstanceHealthResponse.getter(DescribeInstanceHealthResponse::instanceStates)).setter(DescribeInstanceHealthResponse.setter(Builder::instanceStates)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceStates").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(InstanceState::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTANCE_STATES_FIELD));
    private final List<InstanceState> instanceStates;

    private DescribeInstanceHealthResponse(BuilderImpl builder) {
        super(builder);
        this.instanceStates = builder.instanceStates;
    }

    public List<InstanceState> instanceStates() {
        return this.instanceStates;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceStates());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeInstanceHealthResponse)) {
            return false;
        }
        DescribeInstanceHealthResponse other = (DescribeInstanceHealthResponse)((Object)obj);
        return Objects.equals(this.instanceStates(), other.instanceStates());
    }

    public String toString() {
        return ToString.builder((String)"DescribeInstanceHealthResponse").add("InstanceStates", this.instanceStates()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "InstanceStates": {
                return Optional.ofNullable(clazz.cast(this.instanceStates()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeInstanceHealthResponse, T> g) {
        return obj -> g.apply((DescribeInstanceHealthResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ElasticLoadBalancingResponse.BuilderImpl
    implements Builder {
        private List<InstanceState> instanceStates = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeInstanceHealthResponse model) {
            super(model);
            this.instanceStates(model.instanceStates);
        }

        public final Collection<InstanceState.Builder> getInstanceStates() {
            return this.instanceStates != null ? (Collection)this.instanceStates.stream().map(InstanceState::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder instanceStates(Collection<InstanceState> instanceStates) {
            this.instanceStates = InstanceStatesCopier.copy(instanceStates);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instanceStates(InstanceState ... instanceStates) {
            this.instanceStates(Arrays.asList(instanceStates));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instanceStates(Consumer<InstanceState.Builder> ... instanceStates) {
            this.instanceStates(Stream.of(instanceStates).map(c -> (InstanceState)((InstanceState.Builder)InstanceState.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setInstanceStates(Collection<InstanceState.BuilderImpl> instanceStates) {
            this.instanceStates = InstanceStatesCopier.copyFromBuilder(instanceStates);
        }

        @Override
        public DescribeInstanceHealthResponse build() {
            return new DescribeInstanceHealthResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ElasticLoadBalancingResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeInstanceHealthResponse> {
        public Builder instanceStates(Collection<InstanceState> var1);

        public Builder instanceStates(InstanceState ... var1);

        public Builder instanceStates(Consumer<InstanceState.Builder> ... var1);
    }
}

