/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticloadbalancing.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.elasticloadbalancing.model.ElasticLoadBalancingResponse;
import software.amazon.awssdk.services.elasticloadbalancing.model.PolicyTypeDescription;
import software.amazon.awssdk.services.elasticloadbalancing.model.PolicyTypeDescriptionsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeLoadBalancerPolicyTypesResponse
extends ElasticLoadBalancingResponse
implements ToCopyableBuilder<Builder, DescribeLoadBalancerPolicyTypesResponse> {
    private static final SdkField<List<PolicyTypeDescription>> POLICY_TYPE_DESCRIPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("PolicyTypeDescriptions").getter(DescribeLoadBalancerPolicyTypesResponse.getter(DescribeLoadBalancerPolicyTypesResponse::policyTypeDescriptions)).setter(DescribeLoadBalancerPolicyTypesResponse.setter(Builder::policyTypeDescriptions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PolicyTypeDescriptions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(PolicyTypeDescription::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(POLICY_TYPE_DESCRIPTIONS_FIELD));
    private final List<PolicyTypeDescription> policyTypeDescriptions;

    private DescribeLoadBalancerPolicyTypesResponse(BuilderImpl builder) {
        super(builder);
        this.policyTypeDescriptions = builder.policyTypeDescriptions;
    }

    public final boolean hasPolicyTypeDescriptions() {
        return this.policyTypeDescriptions != null && !(this.policyTypeDescriptions instanceof SdkAutoConstructList);
    }

    public final List<PolicyTypeDescription> policyTypeDescriptions() {
        return this.policyTypeDescriptions;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPolicyTypeDescriptions() ? this.policyTypeDescriptions() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeLoadBalancerPolicyTypesResponse)) {
            return false;
        }
        DescribeLoadBalancerPolicyTypesResponse other = (DescribeLoadBalancerPolicyTypesResponse)((Object)obj);
        return this.hasPolicyTypeDescriptions() == other.hasPolicyTypeDescriptions() && Objects.equals(this.policyTypeDescriptions(), other.policyTypeDescriptions());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeLoadBalancerPolicyTypesResponse").add("PolicyTypeDescriptions", this.hasPolicyTypeDescriptions() ? this.policyTypeDescriptions() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "PolicyTypeDescriptions": {
                return Optional.ofNullable(clazz.cast(this.policyTypeDescriptions()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeLoadBalancerPolicyTypesResponse, T> g) {
        return obj -> g.apply((DescribeLoadBalancerPolicyTypesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ElasticLoadBalancingResponse.BuilderImpl
    implements Builder {
        private List<PolicyTypeDescription> policyTypeDescriptions = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeLoadBalancerPolicyTypesResponse model) {
            super(model);
            this.policyTypeDescriptions(model.policyTypeDescriptions);
        }

        public final List<PolicyTypeDescription.Builder> getPolicyTypeDescriptions() {
            List<PolicyTypeDescription.Builder> result = PolicyTypeDescriptionsCopier.copyToBuilder(this.policyTypeDescriptions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPolicyTypeDescriptions(Collection<PolicyTypeDescription.BuilderImpl> policyTypeDescriptions) {
            this.policyTypeDescriptions = PolicyTypeDescriptionsCopier.copyFromBuilder(policyTypeDescriptions);
        }

        @Override
        @Transient
        public final Builder policyTypeDescriptions(Collection<PolicyTypeDescription> policyTypeDescriptions) {
            this.policyTypeDescriptions = PolicyTypeDescriptionsCopier.copy(policyTypeDescriptions);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder policyTypeDescriptions(PolicyTypeDescription ... policyTypeDescriptions) {
            this.policyTypeDescriptions(Arrays.asList(policyTypeDescriptions));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder policyTypeDescriptions(Consumer<PolicyTypeDescription.Builder> ... policyTypeDescriptions) {
            this.policyTypeDescriptions(Stream.of(policyTypeDescriptions).map(c -> (PolicyTypeDescription)((PolicyTypeDescription.Builder)PolicyTypeDescription.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public DescribeLoadBalancerPolicyTypesResponse build() {
            return new DescribeLoadBalancerPolicyTypesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ElasticLoadBalancingResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeLoadBalancerPolicyTypesResponse> {
        public Builder policyTypeDescriptions(Collection<PolicyTypeDescription> var1);

        public Builder policyTypeDescriptions(PolicyTypeDescription ... var1);

        public Builder policyTypeDescriptions(Consumer<PolicyTypeDescription.Builder> ... var1);
    }
}

