/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.elasticloadbalancing.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about a load balancer.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class LoadBalancerDescription implements SdkPojo, Serializable,
        ToCopyableBuilder<LoadBalancerDescription.Builder, LoadBalancerDescription> {
    private static final SdkField<String> LOAD_BALANCER_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LoadBalancerName").getter(getter(LoadBalancerDescription::loadBalancerName))
            .setter(setter(Builder::loadBalancerName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LoadBalancerName").build()).build();

    private static final SdkField<String> DNS_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DNSName").getter(getter(LoadBalancerDescription::dnsName)).setter(setter(Builder::dnsName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DNSName").build()).build();

    private static final SdkField<String> CANONICAL_HOSTED_ZONE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CanonicalHostedZoneName").getter(getter(LoadBalancerDescription::canonicalHostedZoneName))
            .setter(setter(Builder::canonicalHostedZoneName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CanonicalHostedZoneName").build())
            .build();

    private static final SdkField<String> CANONICAL_HOSTED_ZONE_NAME_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CanonicalHostedZoneNameID").getter(getter(LoadBalancerDescription::canonicalHostedZoneNameID))
            .setter(setter(Builder::canonicalHostedZoneNameID))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CanonicalHostedZoneNameID").build())
            .build();

    private static final SdkField<List<ListenerDescription>> LISTENER_DESCRIPTIONS_FIELD = SdkField
            .<List<ListenerDescription>> builder(MarshallingType.LIST)
            .memberName("ListenerDescriptions")
            .getter(getter(LoadBalancerDescription::listenerDescriptions))
            .setter(setter(Builder::listenerDescriptions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ListenerDescriptions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ListenerDescription> builder(MarshallingType.SDK_POJO)
                                            .constructor(ListenerDescription::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Policies> POLICIES_FIELD = SdkField.<Policies> builder(MarshallingType.SDK_POJO)
            .memberName("Policies").getter(getter(LoadBalancerDescription::policies)).setter(setter(Builder::policies))
            .constructor(Policies::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Policies").build()).build();

    private static final SdkField<List<BackendServerDescription>> BACKEND_SERVER_DESCRIPTIONS_FIELD = SdkField
            .<List<BackendServerDescription>> builder(MarshallingType.LIST)
            .memberName("BackendServerDescriptions")
            .getter(getter(LoadBalancerDescription::backendServerDescriptions))
            .setter(setter(Builder::backendServerDescriptions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BackendServerDescriptions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<BackendServerDescription> builder(MarshallingType.SDK_POJO)
                                            .constructor(BackendServerDescription::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> AVAILABILITY_ZONES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("AvailabilityZones")
            .getter(getter(LoadBalancerDescription::availabilityZones))
            .setter(setter(Builder::availabilityZones))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AvailabilityZones").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> SUBNETS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("Subnets")
            .getter(getter(LoadBalancerDescription::subnets))
            .setter(setter(Builder::subnets))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Subnets").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> VPC_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("VPCId")
            .getter(getter(LoadBalancerDescription::vpcId)).setter(setter(Builder::vpcId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VPCId").build()).build();

    private static final SdkField<List<Instance>> INSTANCES_FIELD = SdkField
            .<List<Instance>> builder(MarshallingType.LIST)
            .memberName("Instances")
            .getter(getter(LoadBalancerDescription::instances))
            .setter(setter(Builder::instances))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Instances").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Instance> builder(MarshallingType.SDK_POJO)
                                            .constructor(Instance::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<HealthCheck> HEALTH_CHECK_FIELD = SdkField.<HealthCheck> builder(MarshallingType.SDK_POJO)
            .memberName("HealthCheck").getter(getter(LoadBalancerDescription::healthCheck)).setter(setter(Builder::healthCheck))
            .constructor(HealthCheck::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HealthCheck").build()).build();

    private static final SdkField<SourceSecurityGroup> SOURCE_SECURITY_GROUP_FIELD = SdkField
            .<SourceSecurityGroup> builder(MarshallingType.SDK_POJO).memberName("SourceSecurityGroup")
            .getter(getter(LoadBalancerDescription::sourceSecurityGroup)).setter(setter(Builder::sourceSecurityGroup))
            .constructor(SourceSecurityGroup::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceSecurityGroup").build())
            .build();

    private static final SdkField<List<String>> SECURITY_GROUPS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("SecurityGroups")
            .getter(getter(LoadBalancerDescription::securityGroups))
            .setter(setter(Builder::securityGroups))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecurityGroups").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Instant> CREATED_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreatedTime").getter(getter(LoadBalancerDescription::createdTime)).setter(setter(Builder::createdTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedTime").build()).build();

    private static final SdkField<String> SCHEME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Scheme")
            .getter(getter(LoadBalancerDescription::scheme)).setter(setter(Builder::scheme))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Scheme").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LOAD_BALANCER_NAME_FIELD,
            DNS_NAME_FIELD, CANONICAL_HOSTED_ZONE_NAME_FIELD, CANONICAL_HOSTED_ZONE_NAME_ID_FIELD, LISTENER_DESCRIPTIONS_FIELD,
            POLICIES_FIELD, BACKEND_SERVER_DESCRIPTIONS_FIELD, AVAILABILITY_ZONES_FIELD, SUBNETS_FIELD, VPC_ID_FIELD,
            INSTANCES_FIELD, HEALTH_CHECK_FIELD, SOURCE_SECURITY_GROUP_FIELD, SECURITY_GROUPS_FIELD, CREATED_TIME_FIELD,
            SCHEME_FIELD));

    private static final long serialVersionUID = 1L;

    private final String loadBalancerName;

    private final String dnsName;

    private final String canonicalHostedZoneName;

    private final String canonicalHostedZoneNameID;

    private final List<ListenerDescription> listenerDescriptions;

    private final Policies policies;

    private final List<BackendServerDescription> backendServerDescriptions;

    private final List<String> availabilityZones;

    private final List<String> subnets;

    private final String vpcId;

    private final List<Instance> instances;

    private final HealthCheck healthCheck;

    private final SourceSecurityGroup sourceSecurityGroup;

    private final List<String> securityGroups;

    private final Instant createdTime;

    private final String scheme;

    private LoadBalancerDescription(BuilderImpl builder) {
        this.loadBalancerName = builder.loadBalancerName;
        this.dnsName = builder.dnsName;
        this.canonicalHostedZoneName = builder.canonicalHostedZoneName;
        this.canonicalHostedZoneNameID = builder.canonicalHostedZoneNameID;
        this.listenerDescriptions = builder.listenerDescriptions;
        this.policies = builder.policies;
        this.backendServerDescriptions = builder.backendServerDescriptions;
        this.availabilityZones = builder.availabilityZones;
        this.subnets = builder.subnets;
        this.vpcId = builder.vpcId;
        this.instances = builder.instances;
        this.healthCheck = builder.healthCheck;
        this.sourceSecurityGroup = builder.sourceSecurityGroup;
        this.securityGroups = builder.securityGroups;
        this.createdTime = builder.createdTime;
        this.scheme = builder.scheme;
    }

    /**
     * <p>
     * The name of the load balancer.
     * </p>
     * 
     * @return The name of the load balancer.
     */
    public final String loadBalancerName() {
        return loadBalancerName;
    }

    /**
     * <p>
     * The DNS name of the load balancer.
     * </p>
     * 
     * @return The DNS name of the load balancer.
     */
    public final String dnsName() {
        return dnsName;
    }

    /**
     * <p>
     * The DNS name of the load balancer.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/elasticloadbalancing/latest/classic/using-domain-names-with-elb.html">Configure
     * a Custom Domain Name</a> in the <i>Classic Load Balancers Guide</i>.
     * </p>
     * 
     * @return The DNS name of the load balancer.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/elasticloadbalancing/latest/classic/using-domain-names-with-elb.html"
     *         >Configure a Custom Domain Name</a> in the <i>Classic Load Balancers Guide</i>.
     */
    public final String canonicalHostedZoneName() {
        return canonicalHostedZoneName;
    }

    /**
     * <p>
     * The ID of the Amazon Route 53 hosted zone for the load balancer.
     * </p>
     * 
     * @return The ID of the Amazon Route 53 hosted zone for the load balancer.
     */
    public final String canonicalHostedZoneNameID() {
        return canonicalHostedZoneNameID;
    }

    /**
     * Returns true if the ListenerDescriptions property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public final boolean hasListenerDescriptions() {
        return listenerDescriptions != null && !(listenerDescriptions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The listeners for the load balancer.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasListenerDescriptions()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The listeners for the load balancer.
     */
    public final List<ListenerDescription> listenerDescriptions() {
        return listenerDescriptions;
    }

    /**
     * <p>
     * The policies defined for the load balancer.
     * </p>
     * 
     * @return The policies defined for the load balancer.
     */
    public final Policies policies() {
        return policies;
    }

    /**
     * Returns true if the BackendServerDescriptions property was specified by the sender (it may be empty), or false if
     * the sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public final boolean hasBackendServerDescriptions() {
        return backendServerDescriptions != null && !(backendServerDescriptions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Information about your EC2 instances.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasBackendServerDescriptions()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Information about your EC2 instances.
     */
    public final List<BackendServerDescription> backendServerDescriptions() {
        return backendServerDescriptions;
    }

    /**
     * Returns true if the AvailabilityZones property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public final boolean hasAvailabilityZones() {
        return availabilityZones != null && !(availabilityZones instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The Availability Zones for the load balancer.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasAvailabilityZones()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The Availability Zones for the load balancer.
     */
    public final List<String> availabilityZones() {
        return availabilityZones;
    }

    /**
     * Returns true if the Subnets property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasSubnets() {
        return subnets != null && !(subnets instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The IDs of the subnets for the load balancer.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasSubnets()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The IDs of the subnets for the load balancer.
     */
    public final List<String> subnets() {
        return subnets;
    }

    /**
     * <p>
     * The ID of the VPC for the load balancer.
     * </p>
     * 
     * @return The ID of the VPC for the load balancer.
     */
    public final String vpcId() {
        return vpcId;
    }

    /**
     * Returns true if the Instances property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasInstances() {
        return instances != null && !(instances instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The IDs of the instances for the load balancer.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasInstances()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The IDs of the instances for the load balancer.
     */
    public final List<Instance> instances() {
        return instances;
    }

    /**
     * <p>
     * Information about the health checks conducted on the load balancer.
     * </p>
     * 
     * @return Information about the health checks conducted on the load balancer.
     */
    public final HealthCheck healthCheck() {
        return healthCheck;
    }

    /**
     * <p>
     * The security group for the load balancer, which you can use as part of your inbound rules for your registered
     * instances. To only allow traffic from load balancers, add a security group rule that specifies this source
     * security group as the inbound source.
     * </p>
     * 
     * @return The security group for the load balancer, which you can use as part of your inbound rules for your
     *         registered instances. To only allow traffic from load balancers, add a security group rule that specifies
     *         this source security group as the inbound source.
     */
    public final SourceSecurityGroup sourceSecurityGroup() {
        return sourceSecurityGroup;
    }

    /**
     * Returns true if the SecurityGroups property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasSecurityGroups() {
        return securityGroups != null && !(securityGroups instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The security groups for the load balancer. Valid only for load balancers in a VPC.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasSecurityGroups()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The security groups for the load balancer. Valid only for load balancers in a VPC.
     */
    public final List<String> securityGroups() {
        return securityGroups;
    }

    /**
     * <p>
     * The date and time the load balancer was created.
     * </p>
     * 
     * @return The date and time the load balancer was created.
     */
    public final Instant createdTime() {
        return createdTime;
    }

    /**
     * <p>
     * The type of load balancer. Valid only for load balancers in a VPC.
     * </p>
     * <p>
     * If <code>Scheme</code> is <code>internet-facing</code>, the load balancer has a public DNS name that resolves to
     * a public IP address.
     * </p>
     * <p>
     * If <code>Scheme</code> is <code>internal</code>, the load balancer has a public DNS name that resolves to a
     * private IP address.
     * </p>
     * 
     * @return The type of load balancer. Valid only for load balancers in a VPC.</p>
     *         <p>
     *         If <code>Scheme</code> is <code>internet-facing</code>, the load balancer has a public DNS name that
     *         resolves to a public IP address.
     *         </p>
     *         <p>
     *         If <code>Scheme</code> is <code>internal</code>, the load balancer has a public DNS name that resolves to
     *         a private IP address.
     */
    public final String scheme() {
        return scheme;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(loadBalancerName());
        hashCode = 31 * hashCode + Objects.hashCode(dnsName());
        hashCode = 31 * hashCode + Objects.hashCode(canonicalHostedZoneName());
        hashCode = 31 * hashCode + Objects.hashCode(canonicalHostedZoneNameID());
        hashCode = 31 * hashCode + Objects.hashCode(hasListenerDescriptions() ? listenerDescriptions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(policies());
        hashCode = 31 * hashCode + Objects.hashCode(hasBackendServerDescriptions() ? backendServerDescriptions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasAvailabilityZones() ? availabilityZones() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasSubnets() ? subnets() : null);
        hashCode = 31 * hashCode + Objects.hashCode(vpcId());
        hashCode = 31 * hashCode + Objects.hashCode(hasInstances() ? instances() : null);
        hashCode = 31 * hashCode + Objects.hashCode(healthCheck());
        hashCode = 31 * hashCode + Objects.hashCode(sourceSecurityGroup());
        hashCode = 31 * hashCode + Objects.hashCode(hasSecurityGroups() ? securityGroups() : null);
        hashCode = 31 * hashCode + Objects.hashCode(createdTime());
        hashCode = 31 * hashCode + Objects.hashCode(scheme());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LoadBalancerDescription)) {
            return false;
        }
        LoadBalancerDescription other = (LoadBalancerDescription) obj;
        return Objects.equals(loadBalancerName(), other.loadBalancerName()) && Objects.equals(dnsName(), other.dnsName())
                && Objects.equals(canonicalHostedZoneName(), other.canonicalHostedZoneName())
                && Objects.equals(canonicalHostedZoneNameID(), other.canonicalHostedZoneNameID())
                && hasListenerDescriptions() == other.hasListenerDescriptions()
                && Objects.equals(listenerDescriptions(), other.listenerDescriptions())
                && Objects.equals(policies(), other.policies())
                && hasBackendServerDescriptions() == other.hasBackendServerDescriptions()
                && Objects.equals(backendServerDescriptions(), other.backendServerDescriptions())
                && hasAvailabilityZones() == other.hasAvailabilityZones()
                && Objects.equals(availabilityZones(), other.availabilityZones()) && hasSubnets() == other.hasSubnets()
                && Objects.equals(subnets(), other.subnets()) && Objects.equals(vpcId(), other.vpcId())
                && hasInstances() == other.hasInstances() && Objects.equals(instances(), other.instances())
                && Objects.equals(healthCheck(), other.healthCheck())
                && Objects.equals(sourceSecurityGroup(), other.sourceSecurityGroup())
                && hasSecurityGroups() == other.hasSecurityGroups() && Objects.equals(securityGroups(), other.securityGroups())
                && Objects.equals(createdTime(), other.createdTime()) && Objects.equals(scheme(), other.scheme());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("LoadBalancerDescription").add("LoadBalancerName", loadBalancerName()).add("DNSName", dnsName())
                .add("CanonicalHostedZoneName", canonicalHostedZoneName())
                .add("CanonicalHostedZoneNameID", canonicalHostedZoneNameID())
                .add("ListenerDescriptions", hasListenerDescriptions() ? listenerDescriptions() : null)
                .add("Policies", policies())
                .add("BackendServerDescriptions", hasBackendServerDescriptions() ? backendServerDescriptions() : null)
                .add("AvailabilityZones", hasAvailabilityZones() ? availabilityZones() : null)
                .add("Subnets", hasSubnets() ? subnets() : null).add("VPCId", vpcId())
                .add("Instances", hasInstances() ? instances() : null).add("HealthCheck", healthCheck())
                .add("SourceSecurityGroup", sourceSecurityGroup())
                .add("SecurityGroups", hasSecurityGroups() ? securityGroups() : null).add("CreatedTime", createdTime())
                .add("Scheme", scheme()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "LoadBalancerName":
            return Optional.ofNullable(clazz.cast(loadBalancerName()));
        case "DNSName":
            return Optional.ofNullable(clazz.cast(dnsName()));
        case "CanonicalHostedZoneName":
            return Optional.ofNullable(clazz.cast(canonicalHostedZoneName()));
        case "CanonicalHostedZoneNameID":
            return Optional.ofNullable(clazz.cast(canonicalHostedZoneNameID()));
        case "ListenerDescriptions":
            return Optional.ofNullable(clazz.cast(listenerDescriptions()));
        case "Policies":
            return Optional.ofNullable(clazz.cast(policies()));
        case "BackendServerDescriptions":
            return Optional.ofNullable(clazz.cast(backendServerDescriptions()));
        case "AvailabilityZones":
            return Optional.ofNullable(clazz.cast(availabilityZones()));
        case "Subnets":
            return Optional.ofNullable(clazz.cast(subnets()));
        case "VPCId":
            return Optional.ofNullable(clazz.cast(vpcId()));
        case "Instances":
            return Optional.ofNullable(clazz.cast(instances()));
        case "HealthCheck":
            return Optional.ofNullable(clazz.cast(healthCheck()));
        case "SourceSecurityGroup":
            return Optional.ofNullable(clazz.cast(sourceSecurityGroup()));
        case "SecurityGroups":
            return Optional.ofNullable(clazz.cast(securityGroups()));
        case "CreatedTime":
            return Optional.ofNullable(clazz.cast(createdTime()));
        case "Scheme":
            return Optional.ofNullable(clazz.cast(scheme()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<LoadBalancerDescription, T> g) {
        return obj -> g.apply((LoadBalancerDescription) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, LoadBalancerDescription> {
        /**
         * <p>
         * The name of the load balancer.
         * </p>
         * 
         * @param loadBalancerName
         *        The name of the load balancer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder loadBalancerName(String loadBalancerName);

        /**
         * <p>
         * The DNS name of the load balancer.
         * </p>
         * 
         * @param dnsName
         *        The DNS name of the load balancer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dnsName(String dnsName);

        /**
         * <p>
         * The DNS name of the load balancer.
         * </p>
         * <p>
         * For more information, see <a
         * href="https://docs.aws.amazon.com/elasticloadbalancing/latest/classic/using-domain-names-with-elb.html"
         * >Configure a Custom Domain Name</a> in the <i>Classic Load Balancers Guide</i>.
         * </p>
         * 
         * @param canonicalHostedZoneName
         *        The DNS name of the load balancer.</p>
         *        <p>
         *        For more information, see <a href=
         *        "https://docs.aws.amazon.com/elasticloadbalancing/latest/classic/using-domain-names-with-elb.html"
         *        >Configure a Custom Domain Name</a> in the <i>Classic Load Balancers Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder canonicalHostedZoneName(String canonicalHostedZoneName);

        /**
         * <p>
         * The ID of the Amazon Route 53 hosted zone for the load balancer.
         * </p>
         * 
         * @param canonicalHostedZoneNameID
         *        The ID of the Amazon Route 53 hosted zone for the load balancer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder canonicalHostedZoneNameID(String canonicalHostedZoneNameID);

        /**
         * <p>
         * The listeners for the load balancer.
         * </p>
         * 
         * @param listenerDescriptions
         *        The listeners for the load balancer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder listenerDescriptions(Collection<ListenerDescription> listenerDescriptions);

        /**
         * <p>
         * The listeners for the load balancer.
         * </p>
         * 
         * @param listenerDescriptions
         *        The listeners for the load balancer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder listenerDescriptions(ListenerDescription... listenerDescriptions);

        /**
         * <p>
         * The listeners for the load balancer.
         * </p>
         * This is a convenience that creates an instance of the {@link List<ListenerDescription>.Builder} avoiding the
         * need to create one manually via {@link List<ListenerDescription>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ListenerDescription>.Builder#build()} is called immediately
         * and its result is passed to {@link #listenerDescriptions(List<ListenerDescription>)}.
         * 
         * @param listenerDescriptions
         *        a consumer that will call methods on {@link List<ListenerDescription>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #listenerDescriptions(List<ListenerDescription>)
         */
        Builder listenerDescriptions(Consumer<ListenerDescription.Builder>... listenerDescriptions);

        /**
         * <p>
         * The policies defined for the load balancer.
         * </p>
         * 
         * @param policies
         *        The policies defined for the load balancer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder policies(Policies policies);

        /**
         * <p>
         * The policies defined for the load balancer.
         * </p>
         * This is a convenience that creates an instance of the {@link Policies.Builder} avoiding the need to create
         * one manually via {@link Policies#builder()}.
         *
         * When the {@link Consumer} completes, {@link Policies.Builder#build()} is called immediately and its result is
         * passed to {@link #policies(Policies)}.
         * 
         * @param policies
         *        a consumer that will call methods on {@link Policies.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #policies(Policies)
         */
        default Builder policies(Consumer<Policies.Builder> policies) {
            return policies(Policies.builder().applyMutation(policies).build());
        }

        /**
         * <p>
         * Information about your EC2 instances.
         * </p>
         * 
         * @param backendServerDescriptions
         *        Information about your EC2 instances.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder backendServerDescriptions(Collection<BackendServerDescription> backendServerDescriptions);

        /**
         * <p>
         * Information about your EC2 instances.
         * </p>
         * 
         * @param backendServerDescriptions
         *        Information about your EC2 instances.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder backendServerDescriptions(BackendServerDescription... backendServerDescriptions);

        /**
         * <p>
         * Information about your EC2 instances.
         * </p>
         * This is a convenience that creates an instance of the {@link List<BackendServerDescription>.Builder} avoiding
         * the need to create one manually via {@link List<BackendServerDescription>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<BackendServerDescription>.Builder#build()} is called
         * immediately and its result is passed to {@link #backendServerDescriptions(List<BackendServerDescription>)}.
         * 
         * @param backendServerDescriptions
         *        a consumer that will call methods on {@link List<BackendServerDescription>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #backendServerDescriptions(List<BackendServerDescription>)
         */
        Builder backendServerDescriptions(Consumer<BackendServerDescription.Builder>... backendServerDescriptions);

        /**
         * <p>
         * The Availability Zones for the load balancer.
         * </p>
         * 
         * @param availabilityZones
         *        The Availability Zones for the load balancer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder availabilityZones(Collection<String> availabilityZones);

        /**
         * <p>
         * The Availability Zones for the load balancer.
         * </p>
         * 
         * @param availabilityZones
         *        The Availability Zones for the load balancer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder availabilityZones(String... availabilityZones);

        /**
         * <p>
         * The IDs of the subnets for the load balancer.
         * </p>
         * 
         * @param subnets
         *        The IDs of the subnets for the load balancer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subnets(Collection<String> subnets);

        /**
         * <p>
         * The IDs of the subnets for the load balancer.
         * </p>
         * 
         * @param subnets
         *        The IDs of the subnets for the load balancer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subnets(String... subnets);

        /**
         * <p>
         * The ID of the VPC for the load balancer.
         * </p>
         * 
         * @param vpcId
         *        The ID of the VPC for the load balancer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcId(String vpcId);

        /**
         * <p>
         * The IDs of the instances for the load balancer.
         * </p>
         * 
         * @param instances
         *        The IDs of the instances for the load balancer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instances(Collection<Instance> instances);

        /**
         * <p>
         * The IDs of the instances for the load balancer.
         * </p>
         * 
         * @param instances
         *        The IDs of the instances for the load balancer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instances(Instance... instances);

        /**
         * <p>
         * The IDs of the instances for the load balancer.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Instance>.Builder} avoiding the need to
         * create one manually via {@link List<Instance>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Instance>.Builder#build()} is called immediately and its
         * result is passed to {@link #instances(List<Instance>)}.
         * 
         * @param instances
         *        a consumer that will call methods on {@link List<Instance>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #instances(List<Instance>)
         */
        Builder instances(Consumer<Instance.Builder>... instances);

        /**
         * <p>
         * Information about the health checks conducted on the load balancer.
         * </p>
         * 
         * @param healthCheck
         *        Information about the health checks conducted on the load balancer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder healthCheck(HealthCheck healthCheck);

        /**
         * <p>
         * Information about the health checks conducted on the load balancer.
         * </p>
         * This is a convenience that creates an instance of the {@link HealthCheck.Builder} avoiding the need to create
         * one manually via {@link HealthCheck#builder()}.
         *
         * When the {@link Consumer} completes, {@link HealthCheck.Builder#build()} is called immediately and its result
         * is passed to {@link #healthCheck(HealthCheck)}.
         * 
         * @param healthCheck
         *        a consumer that will call methods on {@link HealthCheck.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #healthCheck(HealthCheck)
         */
        default Builder healthCheck(Consumer<HealthCheck.Builder> healthCheck) {
            return healthCheck(HealthCheck.builder().applyMutation(healthCheck).build());
        }

        /**
         * <p>
         * The security group for the load balancer, which you can use as part of your inbound rules for your registered
         * instances. To only allow traffic from load balancers, add a security group rule that specifies this source
         * security group as the inbound source.
         * </p>
         * 
         * @param sourceSecurityGroup
         *        The security group for the load balancer, which you can use as part of your inbound rules for your
         *        registered instances. To only allow traffic from load balancers, add a security group rule that
         *        specifies this source security group as the inbound source.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceSecurityGroup(SourceSecurityGroup sourceSecurityGroup);

        /**
         * <p>
         * The security group for the load balancer, which you can use as part of your inbound rules for your registered
         * instances. To only allow traffic from load balancers, add a security group rule that specifies this source
         * security group as the inbound source.
         * </p>
         * This is a convenience that creates an instance of the {@link SourceSecurityGroup.Builder} avoiding the need
         * to create one manually via {@link SourceSecurityGroup#builder()}.
         *
         * When the {@link Consumer} completes, {@link SourceSecurityGroup.Builder#build()} is called immediately and
         * its result is passed to {@link #sourceSecurityGroup(SourceSecurityGroup)}.
         * 
         * @param sourceSecurityGroup
         *        a consumer that will call methods on {@link SourceSecurityGroup.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sourceSecurityGroup(SourceSecurityGroup)
         */
        default Builder sourceSecurityGroup(Consumer<SourceSecurityGroup.Builder> sourceSecurityGroup) {
            return sourceSecurityGroup(SourceSecurityGroup.builder().applyMutation(sourceSecurityGroup).build());
        }

        /**
         * <p>
         * The security groups for the load balancer. Valid only for load balancers in a VPC.
         * </p>
         * 
         * @param securityGroups
         *        The security groups for the load balancer. Valid only for load balancers in a VPC.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder securityGroups(Collection<String> securityGroups);

        /**
         * <p>
         * The security groups for the load balancer. Valid only for load balancers in a VPC.
         * </p>
         * 
         * @param securityGroups
         *        The security groups for the load balancer. Valid only for load balancers in a VPC.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder securityGroups(String... securityGroups);

        /**
         * <p>
         * The date and time the load balancer was created.
         * </p>
         * 
         * @param createdTime
         *        The date and time the load balancer was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdTime(Instant createdTime);

        /**
         * <p>
         * The type of load balancer. Valid only for load balancers in a VPC.
         * </p>
         * <p>
         * If <code>Scheme</code> is <code>internet-facing</code>, the load balancer has a public DNS name that resolves
         * to a public IP address.
         * </p>
         * <p>
         * If <code>Scheme</code> is <code>internal</code>, the load balancer has a public DNS name that resolves to a
         * private IP address.
         * </p>
         * 
         * @param scheme
         *        The type of load balancer. Valid only for load balancers in a VPC.</p>
         *        <p>
         *        If <code>Scheme</code> is <code>internet-facing</code>, the load balancer has a public DNS name that
         *        resolves to a public IP address.
         *        </p>
         *        <p>
         *        If <code>Scheme</code> is <code>internal</code>, the load balancer has a public DNS name that resolves
         *        to a private IP address.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scheme(String scheme);
    }

    static final class BuilderImpl implements Builder {
        private String loadBalancerName;

        private String dnsName;

        private String canonicalHostedZoneName;

        private String canonicalHostedZoneNameID;

        private List<ListenerDescription> listenerDescriptions = DefaultSdkAutoConstructList.getInstance();

        private Policies policies;

        private List<BackendServerDescription> backendServerDescriptions = DefaultSdkAutoConstructList.getInstance();

        private List<String> availabilityZones = DefaultSdkAutoConstructList.getInstance();

        private List<String> subnets = DefaultSdkAutoConstructList.getInstance();

        private String vpcId;

        private List<Instance> instances = DefaultSdkAutoConstructList.getInstance();

        private HealthCheck healthCheck;

        private SourceSecurityGroup sourceSecurityGroup;

        private List<String> securityGroups = DefaultSdkAutoConstructList.getInstance();

        private Instant createdTime;

        private String scheme;

        private BuilderImpl() {
        }

        private BuilderImpl(LoadBalancerDescription model) {
            loadBalancerName(model.loadBalancerName);
            dnsName(model.dnsName);
            canonicalHostedZoneName(model.canonicalHostedZoneName);
            canonicalHostedZoneNameID(model.canonicalHostedZoneNameID);
            listenerDescriptions(model.listenerDescriptions);
            policies(model.policies);
            backendServerDescriptions(model.backendServerDescriptions);
            availabilityZones(model.availabilityZones);
            subnets(model.subnets);
            vpcId(model.vpcId);
            instances(model.instances);
            healthCheck(model.healthCheck);
            sourceSecurityGroup(model.sourceSecurityGroup);
            securityGroups(model.securityGroups);
            createdTime(model.createdTime);
            scheme(model.scheme);
        }

        public final String getLoadBalancerName() {
            return loadBalancerName;
        }

        @Override
        public final Builder loadBalancerName(String loadBalancerName) {
            this.loadBalancerName = loadBalancerName;
            return this;
        }

        public final void setLoadBalancerName(String loadBalancerName) {
            this.loadBalancerName = loadBalancerName;
        }

        public final String getDnsName() {
            return dnsName;
        }

        @Override
        public final Builder dnsName(String dnsName) {
            this.dnsName = dnsName;
            return this;
        }

        public final void setDnsName(String dnsName) {
            this.dnsName = dnsName;
        }

        public final String getCanonicalHostedZoneName() {
            return canonicalHostedZoneName;
        }

        @Override
        public final Builder canonicalHostedZoneName(String canonicalHostedZoneName) {
            this.canonicalHostedZoneName = canonicalHostedZoneName;
            return this;
        }

        public final void setCanonicalHostedZoneName(String canonicalHostedZoneName) {
            this.canonicalHostedZoneName = canonicalHostedZoneName;
        }

        public final String getCanonicalHostedZoneNameID() {
            return canonicalHostedZoneNameID;
        }

        @Override
        public final Builder canonicalHostedZoneNameID(String canonicalHostedZoneNameID) {
            this.canonicalHostedZoneNameID = canonicalHostedZoneNameID;
            return this;
        }

        public final void setCanonicalHostedZoneNameID(String canonicalHostedZoneNameID) {
            this.canonicalHostedZoneNameID = canonicalHostedZoneNameID;
        }

        public final Collection<ListenerDescription.Builder> getListenerDescriptions() {
            if (listenerDescriptions instanceof SdkAutoConstructList) {
                return null;
            }
            return listenerDescriptions != null ? listenerDescriptions.stream().map(ListenerDescription::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder listenerDescriptions(Collection<ListenerDescription> listenerDescriptions) {
            this.listenerDescriptions = ListenerDescriptionsCopier.copy(listenerDescriptions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder listenerDescriptions(ListenerDescription... listenerDescriptions) {
            listenerDescriptions(Arrays.asList(listenerDescriptions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder listenerDescriptions(Consumer<ListenerDescription.Builder>... listenerDescriptions) {
            listenerDescriptions(Stream.of(listenerDescriptions).map(c -> ListenerDescription.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setListenerDescriptions(Collection<ListenerDescription.BuilderImpl> listenerDescriptions) {
            this.listenerDescriptions = ListenerDescriptionsCopier.copyFromBuilder(listenerDescriptions);
        }

        public final Policies.Builder getPolicies() {
            return policies != null ? policies.toBuilder() : null;
        }

        @Override
        public final Builder policies(Policies policies) {
            this.policies = policies;
            return this;
        }

        public final void setPolicies(Policies.BuilderImpl policies) {
            this.policies = policies != null ? policies.build() : null;
        }

        public final Collection<BackendServerDescription.Builder> getBackendServerDescriptions() {
            if (backendServerDescriptions instanceof SdkAutoConstructList) {
                return null;
            }
            return backendServerDescriptions != null ? backendServerDescriptions.stream()
                    .map(BackendServerDescription::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder backendServerDescriptions(Collection<BackendServerDescription> backendServerDescriptions) {
            this.backendServerDescriptions = BackendServerDescriptionsCopier.copy(backendServerDescriptions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder backendServerDescriptions(BackendServerDescription... backendServerDescriptions) {
            backendServerDescriptions(Arrays.asList(backendServerDescriptions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder backendServerDescriptions(Consumer<BackendServerDescription.Builder>... backendServerDescriptions) {
            backendServerDescriptions(Stream.of(backendServerDescriptions)
                    .map(c -> BackendServerDescription.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setBackendServerDescriptions(Collection<BackendServerDescription.BuilderImpl> backendServerDescriptions) {
            this.backendServerDescriptions = BackendServerDescriptionsCopier.copyFromBuilder(backendServerDescriptions);
        }

        public final Collection<String> getAvailabilityZones() {
            if (availabilityZones instanceof SdkAutoConstructList) {
                return null;
            }
            return availabilityZones;
        }

        @Override
        public final Builder availabilityZones(Collection<String> availabilityZones) {
            this.availabilityZones = AvailabilityZonesCopier.copy(availabilityZones);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder availabilityZones(String... availabilityZones) {
            availabilityZones(Arrays.asList(availabilityZones));
            return this;
        }

        public final void setAvailabilityZones(Collection<String> availabilityZones) {
            this.availabilityZones = AvailabilityZonesCopier.copy(availabilityZones);
        }

        public final Collection<String> getSubnets() {
            if (subnets instanceof SdkAutoConstructList) {
                return null;
            }
            return subnets;
        }

        @Override
        public final Builder subnets(Collection<String> subnets) {
            this.subnets = SubnetsCopier.copy(subnets);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder subnets(String... subnets) {
            subnets(Arrays.asList(subnets));
            return this;
        }

        public final void setSubnets(Collection<String> subnets) {
            this.subnets = SubnetsCopier.copy(subnets);
        }

        public final String getVpcId() {
            return vpcId;
        }

        @Override
        public final Builder vpcId(String vpcId) {
            this.vpcId = vpcId;
            return this;
        }

        public final void setVpcId(String vpcId) {
            this.vpcId = vpcId;
        }

        public final Collection<Instance.Builder> getInstances() {
            if (instances instanceof SdkAutoConstructList) {
                return null;
            }
            return instances != null ? instances.stream().map(Instance::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder instances(Collection<Instance> instances) {
            this.instances = InstancesCopier.copy(instances);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instances(Instance... instances) {
            instances(Arrays.asList(instances));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instances(Consumer<Instance.Builder>... instances) {
            instances(Stream.of(instances).map(c -> Instance.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setInstances(Collection<Instance.BuilderImpl> instances) {
            this.instances = InstancesCopier.copyFromBuilder(instances);
        }

        public final HealthCheck.Builder getHealthCheck() {
            return healthCheck != null ? healthCheck.toBuilder() : null;
        }

        @Override
        public final Builder healthCheck(HealthCheck healthCheck) {
            this.healthCheck = healthCheck;
            return this;
        }

        public final void setHealthCheck(HealthCheck.BuilderImpl healthCheck) {
            this.healthCheck = healthCheck != null ? healthCheck.build() : null;
        }

        public final SourceSecurityGroup.Builder getSourceSecurityGroup() {
            return sourceSecurityGroup != null ? sourceSecurityGroup.toBuilder() : null;
        }

        @Override
        public final Builder sourceSecurityGroup(SourceSecurityGroup sourceSecurityGroup) {
            this.sourceSecurityGroup = sourceSecurityGroup;
            return this;
        }

        public final void setSourceSecurityGroup(SourceSecurityGroup.BuilderImpl sourceSecurityGroup) {
            this.sourceSecurityGroup = sourceSecurityGroup != null ? sourceSecurityGroup.build() : null;
        }

        public final Collection<String> getSecurityGroups() {
            if (securityGroups instanceof SdkAutoConstructList) {
                return null;
            }
            return securityGroups;
        }

        @Override
        public final Builder securityGroups(Collection<String> securityGroups) {
            this.securityGroups = SecurityGroupsCopier.copy(securityGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder securityGroups(String... securityGroups) {
            securityGroups(Arrays.asList(securityGroups));
            return this;
        }

        public final void setSecurityGroups(Collection<String> securityGroups) {
            this.securityGroups = SecurityGroupsCopier.copy(securityGroups);
        }

        public final Instant getCreatedTime() {
            return createdTime;
        }

        @Override
        public final Builder createdTime(Instant createdTime) {
            this.createdTime = createdTime;
            return this;
        }

        public final void setCreatedTime(Instant createdTime) {
            this.createdTime = createdTime;
        }

        public final String getScheme() {
            return scheme;
        }

        @Override
        public final Builder scheme(String scheme) {
            this.scheme = scheme;
            return this;
        }

        public final void setScheme(String scheme) {
            this.scheme = scheme;
        }

        @Override
        public LoadBalancerDescription build() {
            return new LoadBalancerDescription(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
