/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.elasticloadbalancing.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The attributes for a load balancer.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class LoadBalancerAttributes implements SdkPojo, Serializable,
        ToCopyableBuilder<LoadBalancerAttributes.Builder, LoadBalancerAttributes> {
    private static final SdkField<CrossZoneLoadBalancing> CROSS_ZONE_LOAD_BALANCING_FIELD = SdkField
            .<CrossZoneLoadBalancing> builder(MarshallingType.SDK_POJO).memberName("CrossZoneLoadBalancing")
            .getter(getter(LoadBalancerAttributes::crossZoneLoadBalancing)).setter(setter(Builder::crossZoneLoadBalancing))
            .constructor(CrossZoneLoadBalancing::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CrossZoneLoadBalancing").build())
            .build();

    private static final SdkField<AccessLog> ACCESS_LOG_FIELD = SdkField.<AccessLog> builder(MarshallingType.SDK_POJO)
            .memberName("AccessLog").getter(getter(LoadBalancerAttributes::accessLog)).setter(setter(Builder::accessLog))
            .constructor(AccessLog::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccessLog").build()).build();

    private static final SdkField<ConnectionDraining> CONNECTION_DRAINING_FIELD = SdkField
            .<ConnectionDraining> builder(MarshallingType.SDK_POJO).memberName("ConnectionDraining")
            .getter(getter(LoadBalancerAttributes::connectionDraining)).setter(setter(Builder::connectionDraining))
            .constructor(ConnectionDraining::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConnectionDraining").build())
            .build();

    private static final SdkField<ConnectionSettings> CONNECTION_SETTINGS_FIELD = SdkField
            .<ConnectionSettings> builder(MarshallingType.SDK_POJO).memberName("ConnectionSettings")
            .getter(getter(LoadBalancerAttributes::connectionSettings)).setter(setter(Builder::connectionSettings))
            .constructor(ConnectionSettings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConnectionSettings").build())
            .build();

    private static final SdkField<List<AdditionalAttribute>> ADDITIONAL_ATTRIBUTES_FIELD = SdkField
            .<List<AdditionalAttribute>> builder(MarshallingType.LIST)
            .memberName("AdditionalAttributes")
            .getter(getter(LoadBalancerAttributes::additionalAttributes))
            .setter(setter(Builder::additionalAttributes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AdditionalAttributes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AdditionalAttribute> builder(MarshallingType.SDK_POJO)
                                            .constructor(AdditionalAttribute::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            CROSS_ZONE_LOAD_BALANCING_FIELD, ACCESS_LOG_FIELD, CONNECTION_DRAINING_FIELD, CONNECTION_SETTINGS_FIELD,
            ADDITIONAL_ATTRIBUTES_FIELD));

    private static final long serialVersionUID = 1L;

    private final CrossZoneLoadBalancing crossZoneLoadBalancing;

    private final AccessLog accessLog;

    private final ConnectionDraining connectionDraining;

    private final ConnectionSettings connectionSettings;

    private final List<AdditionalAttribute> additionalAttributes;

    private LoadBalancerAttributes(BuilderImpl builder) {
        this.crossZoneLoadBalancing = builder.crossZoneLoadBalancing;
        this.accessLog = builder.accessLog;
        this.connectionDraining = builder.connectionDraining;
        this.connectionSettings = builder.connectionSettings;
        this.additionalAttributes = builder.additionalAttributes;
    }

    /**
     * <p>
     * If enabled, the load balancer routes the request traffic evenly across all instances regardless of the
     * Availability Zones.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/elasticloadbalancing/latest/classic/enable-disable-crosszone-lb.html">Configure
     * Cross-Zone Load Balancing</a> in the <i>Classic Load Balancers Guide</i>.
     * </p>
     * 
     * @return If enabled, the load balancer routes the request traffic evenly across all instances regardless of the
     *         Availability Zones.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/elasticloadbalancing/latest/classic/enable-disable-crosszone-lb.html"
     *         >Configure Cross-Zone Load Balancing</a> in the <i>Classic Load Balancers Guide</i>.
     */
    public final CrossZoneLoadBalancing crossZoneLoadBalancing() {
        return crossZoneLoadBalancing;
    }

    /**
     * <p>
     * If enabled, the load balancer captures detailed information of all requests and delivers the information to the
     * Amazon S3 bucket that you specify.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/elasticloadbalancing/latest/classic/enable-access-logs.html">Enable Access
     * Logs</a> in the <i>Classic Load Balancers Guide</i>.
     * </p>
     * 
     * @return If enabled, the load balancer captures detailed information of all requests and delivers the information
     *         to the Amazon S3 bucket that you specify.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/elasticloadbalancing/latest/classic/enable-access-logs.html">Enable
     *         Access Logs</a> in the <i>Classic Load Balancers Guide</i>.
     */
    public final AccessLog accessLog() {
        return accessLog;
    }

    /**
     * <p>
     * If enabled, the load balancer allows existing requests to complete before the load balancer shifts traffic away
     * from a deregistered or unhealthy instance.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/elasticloadbalancing/latest/classic/config-conn-drain.html">Configure
     * Connection Draining</a> in the <i>Classic Load Balancers Guide</i>.
     * </p>
     * 
     * @return If enabled, the load balancer allows existing requests to complete before the load balancer shifts
     *         traffic away from a deregistered or unhealthy instance.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/elasticloadbalancing/latest/classic/config-conn-drain.html">Configure
     *         Connection Draining</a> in the <i>Classic Load Balancers Guide</i>.
     */
    public final ConnectionDraining connectionDraining() {
        return connectionDraining;
    }

    /**
     * <p>
     * If enabled, the load balancer allows the connections to remain idle (no data is sent over the connection) for the
     * specified duration.
     * </p>
     * <p>
     * By default, Elastic Load Balancing maintains a 60-second idle connection timeout for both front-end and back-end
     * connections of your load balancer. For more information, see <a
     * href="https://docs.aws.amazon.com/elasticloadbalancing/latest/classic/config-idle-timeout.html">Configure Idle
     * Connection Timeout</a> in the <i>Classic Load Balancers Guide</i>.
     * </p>
     * 
     * @return If enabled, the load balancer allows the connections to remain idle (no data is sent over the connection)
     *         for the specified duration.</p>
     *         <p>
     *         By default, Elastic Load Balancing maintains a 60-second idle connection timeout for both front-end and
     *         back-end connections of your load balancer. For more information, see <a
     *         href="https://docs.aws.amazon.com/elasticloadbalancing/latest/classic/config-idle-timeout.html">Configure
     *         Idle Connection Timeout</a> in the <i>Classic Load Balancers Guide</i>.
     */
    public final ConnectionSettings connectionSettings() {
        return connectionSettings;
    }

    /**
     * Returns true if the AdditionalAttributes property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public final boolean hasAdditionalAttributes() {
        return additionalAttributes != null && !(additionalAttributes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Any additional attributes.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasAdditionalAttributes()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Any additional attributes.
     */
    public final List<AdditionalAttribute> additionalAttributes() {
        return additionalAttributes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(crossZoneLoadBalancing());
        hashCode = 31 * hashCode + Objects.hashCode(accessLog());
        hashCode = 31 * hashCode + Objects.hashCode(connectionDraining());
        hashCode = 31 * hashCode + Objects.hashCode(connectionSettings());
        hashCode = 31 * hashCode + Objects.hashCode(hasAdditionalAttributes() ? additionalAttributes() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LoadBalancerAttributes)) {
            return false;
        }
        LoadBalancerAttributes other = (LoadBalancerAttributes) obj;
        return Objects.equals(crossZoneLoadBalancing(), other.crossZoneLoadBalancing())
                && Objects.equals(accessLog(), other.accessLog())
                && Objects.equals(connectionDraining(), other.connectionDraining())
                && Objects.equals(connectionSettings(), other.connectionSettings())
                && hasAdditionalAttributes() == other.hasAdditionalAttributes()
                && Objects.equals(additionalAttributes(), other.additionalAttributes());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("LoadBalancerAttributes").add("CrossZoneLoadBalancing", crossZoneLoadBalancing())
                .add("AccessLog", accessLog()).add("ConnectionDraining", connectionDraining())
                .add("ConnectionSettings", connectionSettings())
                .add("AdditionalAttributes", hasAdditionalAttributes() ? additionalAttributes() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CrossZoneLoadBalancing":
            return Optional.ofNullable(clazz.cast(crossZoneLoadBalancing()));
        case "AccessLog":
            return Optional.ofNullable(clazz.cast(accessLog()));
        case "ConnectionDraining":
            return Optional.ofNullable(clazz.cast(connectionDraining()));
        case "ConnectionSettings":
            return Optional.ofNullable(clazz.cast(connectionSettings()));
        case "AdditionalAttributes":
            return Optional.ofNullable(clazz.cast(additionalAttributes()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<LoadBalancerAttributes, T> g) {
        return obj -> g.apply((LoadBalancerAttributes) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, LoadBalancerAttributes> {
        /**
         * <p>
         * If enabled, the load balancer routes the request traffic evenly across all instances regardless of the
         * Availability Zones.
         * </p>
         * <p>
         * For more information, see <a
         * href="https://docs.aws.amazon.com/elasticloadbalancing/latest/classic/enable-disable-crosszone-lb.html"
         * >Configure Cross-Zone Load Balancing</a> in the <i>Classic Load Balancers Guide</i>.
         * </p>
         * 
         * @param crossZoneLoadBalancing
         *        If enabled, the load balancer routes the request traffic evenly across all instances regardless of the
         *        Availability Zones.</p>
         *        <p>
         *        For more information, see <a href=
         *        "https://docs.aws.amazon.com/elasticloadbalancing/latest/classic/enable-disable-crosszone-lb.html"
         *        >Configure Cross-Zone Load Balancing</a> in the <i>Classic Load Balancers Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder crossZoneLoadBalancing(CrossZoneLoadBalancing crossZoneLoadBalancing);

        /**
         * <p>
         * If enabled, the load balancer routes the request traffic evenly across all instances regardless of the
         * Availability Zones.
         * </p>
         * <p>
         * For more information, see <a
         * href="https://docs.aws.amazon.com/elasticloadbalancing/latest/classic/enable-disable-crosszone-lb.html"
         * >Configure Cross-Zone Load Balancing</a> in the <i>Classic Load Balancers Guide</i>.
         * </p>
         * This is a convenience that creates an instance of the {@link CrossZoneLoadBalancing.Builder} avoiding the
         * need to create one manually via {@link CrossZoneLoadBalancing#builder()}.
         *
         * When the {@link Consumer} completes, {@link CrossZoneLoadBalancing.Builder#build()} is called immediately and
         * its result is passed to {@link #crossZoneLoadBalancing(CrossZoneLoadBalancing)}.
         * 
         * @param crossZoneLoadBalancing
         *        a consumer that will call methods on {@link CrossZoneLoadBalancing.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #crossZoneLoadBalancing(CrossZoneLoadBalancing)
         */
        default Builder crossZoneLoadBalancing(Consumer<CrossZoneLoadBalancing.Builder> crossZoneLoadBalancing) {
            return crossZoneLoadBalancing(CrossZoneLoadBalancing.builder().applyMutation(crossZoneLoadBalancing).build());
        }

        /**
         * <p>
         * If enabled, the load balancer captures detailed information of all requests and delivers the information to
         * the Amazon S3 bucket that you specify.
         * </p>
         * <p>
         * For more information, see <a
         * href="https://docs.aws.amazon.com/elasticloadbalancing/latest/classic/enable-access-logs.html">Enable Access
         * Logs</a> in the <i>Classic Load Balancers Guide</i>.
         * </p>
         * 
         * @param accessLog
         *        If enabled, the load balancer captures detailed information of all requests and delivers the
         *        information to the Amazon S3 bucket that you specify.</p>
         *        <p>
         *        For more information, see <a
         *        href="https://docs.aws.amazon.com/elasticloadbalancing/latest/classic/enable-access-logs.html">Enable
         *        Access Logs</a> in the <i>Classic Load Balancers Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accessLog(AccessLog accessLog);

        /**
         * <p>
         * If enabled, the load balancer captures detailed information of all requests and delivers the information to
         * the Amazon S3 bucket that you specify.
         * </p>
         * <p>
         * For more information, see <a
         * href="https://docs.aws.amazon.com/elasticloadbalancing/latest/classic/enable-access-logs.html">Enable Access
         * Logs</a> in the <i>Classic Load Balancers Guide</i>.
         * </p>
         * This is a convenience that creates an instance of the {@link AccessLog.Builder} avoiding the need to create
         * one manually via {@link AccessLog#builder()}.
         *
         * When the {@link Consumer} completes, {@link AccessLog.Builder#build()} is called immediately and its result
         * is passed to {@link #accessLog(AccessLog)}.
         * 
         * @param accessLog
         *        a consumer that will call methods on {@link AccessLog.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #accessLog(AccessLog)
         */
        default Builder accessLog(Consumer<AccessLog.Builder> accessLog) {
            return accessLog(AccessLog.builder().applyMutation(accessLog).build());
        }

        /**
         * <p>
         * If enabled, the load balancer allows existing requests to complete before the load balancer shifts traffic
         * away from a deregistered or unhealthy instance.
         * </p>
         * <p>
         * For more information, see <a
         * href="https://docs.aws.amazon.com/elasticloadbalancing/latest/classic/config-conn-drain.html">Configure
         * Connection Draining</a> in the <i>Classic Load Balancers Guide</i>.
         * </p>
         * 
         * @param connectionDraining
         *        If enabled, the load balancer allows existing requests to complete before the load balancer shifts
         *        traffic away from a deregistered or unhealthy instance.</p>
         *        <p>
         *        For more information, see <a
         *        href="https://docs.aws.amazon.com/elasticloadbalancing/latest/classic/config-conn-drain.html"
         *        >Configure Connection Draining</a> in the <i>Classic Load Balancers Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder connectionDraining(ConnectionDraining connectionDraining);

        /**
         * <p>
         * If enabled, the load balancer allows existing requests to complete before the load balancer shifts traffic
         * away from a deregistered or unhealthy instance.
         * </p>
         * <p>
         * For more information, see <a
         * href="https://docs.aws.amazon.com/elasticloadbalancing/latest/classic/config-conn-drain.html">Configure
         * Connection Draining</a> in the <i>Classic Load Balancers Guide</i>.
         * </p>
         * This is a convenience that creates an instance of the {@link ConnectionDraining.Builder} avoiding the need to
         * create one manually via {@link ConnectionDraining#builder()}.
         *
         * When the {@link Consumer} completes, {@link ConnectionDraining.Builder#build()} is called immediately and its
         * result is passed to {@link #connectionDraining(ConnectionDraining)}.
         * 
         * @param connectionDraining
         *        a consumer that will call methods on {@link ConnectionDraining.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #connectionDraining(ConnectionDraining)
         */
        default Builder connectionDraining(Consumer<ConnectionDraining.Builder> connectionDraining) {
            return connectionDraining(ConnectionDraining.builder().applyMutation(connectionDraining).build());
        }

        /**
         * <p>
         * If enabled, the load balancer allows the connections to remain idle (no data is sent over the connection) for
         * the specified duration.
         * </p>
         * <p>
         * By default, Elastic Load Balancing maintains a 60-second idle connection timeout for both front-end and
         * back-end connections of your load balancer. For more information, see <a
         * href="https://docs.aws.amazon.com/elasticloadbalancing/latest/classic/config-idle-timeout.html">Configure
         * Idle Connection Timeout</a> in the <i>Classic Load Balancers Guide</i>.
         * </p>
         * 
         * @param connectionSettings
         *        If enabled, the load balancer allows the connections to remain idle (no data is sent over the
         *        connection) for the specified duration.</p>
         *        <p>
         *        By default, Elastic Load Balancing maintains a 60-second idle connection timeout for both front-end
         *        and back-end connections of your load balancer. For more information, see <a
         *        href="https://docs.aws.amazon.com/elasticloadbalancing/latest/classic/config-idle-timeout.html"
         *        >Configure Idle Connection Timeout</a> in the <i>Classic Load Balancers Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder connectionSettings(ConnectionSettings connectionSettings);

        /**
         * <p>
         * If enabled, the load balancer allows the connections to remain idle (no data is sent over the connection) for
         * the specified duration.
         * </p>
         * <p>
         * By default, Elastic Load Balancing maintains a 60-second idle connection timeout for both front-end and
         * back-end connections of your load balancer. For more information, see <a
         * href="https://docs.aws.amazon.com/elasticloadbalancing/latest/classic/config-idle-timeout.html">Configure
         * Idle Connection Timeout</a> in the <i>Classic Load Balancers Guide</i>.
         * </p>
         * This is a convenience that creates an instance of the {@link ConnectionSettings.Builder} avoiding the need to
         * create one manually via {@link ConnectionSettings#builder()}.
         *
         * When the {@link Consumer} completes, {@link ConnectionSettings.Builder#build()} is called immediately and its
         * result is passed to {@link #connectionSettings(ConnectionSettings)}.
         * 
         * @param connectionSettings
         *        a consumer that will call methods on {@link ConnectionSettings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #connectionSettings(ConnectionSettings)
         */
        default Builder connectionSettings(Consumer<ConnectionSettings.Builder> connectionSettings) {
            return connectionSettings(ConnectionSettings.builder().applyMutation(connectionSettings).build());
        }

        /**
         * <p>
         * Any additional attributes.
         * </p>
         * 
         * @param additionalAttributes
         *        Any additional attributes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder additionalAttributes(Collection<AdditionalAttribute> additionalAttributes);

        /**
         * <p>
         * Any additional attributes.
         * </p>
         * 
         * @param additionalAttributes
         *        Any additional attributes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder additionalAttributes(AdditionalAttribute... additionalAttributes);

        /**
         * <p>
         * Any additional attributes.
         * </p>
         * This is a convenience that creates an instance of the {@link List<AdditionalAttribute>.Builder} avoiding the
         * need to create one manually via {@link List<AdditionalAttribute>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<AdditionalAttribute>.Builder#build()} is called immediately
         * and its result is passed to {@link #additionalAttributes(List<AdditionalAttribute>)}.
         * 
         * @param additionalAttributes
         *        a consumer that will call methods on {@link List<AdditionalAttribute>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #additionalAttributes(List<AdditionalAttribute>)
         */
        Builder additionalAttributes(Consumer<AdditionalAttribute.Builder>... additionalAttributes);
    }

    static final class BuilderImpl implements Builder {
        private CrossZoneLoadBalancing crossZoneLoadBalancing;

        private AccessLog accessLog;

        private ConnectionDraining connectionDraining;

        private ConnectionSettings connectionSettings;

        private List<AdditionalAttribute> additionalAttributes = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(LoadBalancerAttributes model) {
            crossZoneLoadBalancing(model.crossZoneLoadBalancing);
            accessLog(model.accessLog);
            connectionDraining(model.connectionDraining);
            connectionSettings(model.connectionSettings);
            additionalAttributes(model.additionalAttributes);
        }

        public final CrossZoneLoadBalancing.Builder getCrossZoneLoadBalancing() {
            return crossZoneLoadBalancing != null ? crossZoneLoadBalancing.toBuilder() : null;
        }

        @Override
        public final Builder crossZoneLoadBalancing(CrossZoneLoadBalancing crossZoneLoadBalancing) {
            this.crossZoneLoadBalancing = crossZoneLoadBalancing;
            return this;
        }

        public final void setCrossZoneLoadBalancing(CrossZoneLoadBalancing.BuilderImpl crossZoneLoadBalancing) {
            this.crossZoneLoadBalancing = crossZoneLoadBalancing != null ? crossZoneLoadBalancing.build() : null;
        }

        public final AccessLog.Builder getAccessLog() {
            return accessLog != null ? accessLog.toBuilder() : null;
        }

        @Override
        public final Builder accessLog(AccessLog accessLog) {
            this.accessLog = accessLog;
            return this;
        }

        public final void setAccessLog(AccessLog.BuilderImpl accessLog) {
            this.accessLog = accessLog != null ? accessLog.build() : null;
        }

        public final ConnectionDraining.Builder getConnectionDraining() {
            return connectionDraining != null ? connectionDraining.toBuilder() : null;
        }

        @Override
        public final Builder connectionDraining(ConnectionDraining connectionDraining) {
            this.connectionDraining = connectionDraining;
            return this;
        }

        public final void setConnectionDraining(ConnectionDraining.BuilderImpl connectionDraining) {
            this.connectionDraining = connectionDraining != null ? connectionDraining.build() : null;
        }

        public final ConnectionSettings.Builder getConnectionSettings() {
            return connectionSettings != null ? connectionSettings.toBuilder() : null;
        }

        @Override
        public final Builder connectionSettings(ConnectionSettings connectionSettings) {
            this.connectionSettings = connectionSettings;
            return this;
        }

        public final void setConnectionSettings(ConnectionSettings.BuilderImpl connectionSettings) {
            this.connectionSettings = connectionSettings != null ? connectionSettings.build() : null;
        }

        public final Collection<AdditionalAttribute.Builder> getAdditionalAttributes() {
            if (additionalAttributes instanceof SdkAutoConstructList) {
                return null;
            }
            return additionalAttributes != null ? additionalAttributes.stream().map(AdditionalAttribute::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder additionalAttributes(Collection<AdditionalAttribute> additionalAttributes) {
            this.additionalAttributes = AdditionalAttributesCopier.copy(additionalAttributes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder additionalAttributes(AdditionalAttribute... additionalAttributes) {
            additionalAttributes(Arrays.asList(additionalAttributes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder additionalAttributes(Consumer<AdditionalAttribute.Builder>... additionalAttributes) {
            additionalAttributes(Stream.of(additionalAttributes).map(c -> AdditionalAttribute.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setAdditionalAttributes(Collection<AdditionalAttribute.BuilderImpl> additionalAttributes) {
            this.additionalAttributes = AdditionalAttributesCopier.copyFromBuilder(additionalAttributes);
        }

        @Override
        public LoadBalancerAttributes build() {
            return new LoadBalancerAttributes(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
