/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.elasticloadbalancing.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the output of ModifyLoadBalancerAttributes.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ModifyLoadBalancerAttributesResponse extends ElasticLoadBalancingResponse implements
        ToCopyableBuilder<ModifyLoadBalancerAttributesResponse.Builder, ModifyLoadBalancerAttributesResponse> {
    private static final SdkField<String> LOAD_BALANCER_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ModifyLoadBalancerAttributesResponse::loadBalancerName)).setter(setter(Builder::loadBalancerName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LoadBalancerName").build()).build();

    private static final SdkField<LoadBalancerAttributes> LOAD_BALANCER_ATTRIBUTES_FIELD = SdkField
            .<LoadBalancerAttributes> builder(MarshallingType.SDK_POJO)
            .getter(getter(ModifyLoadBalancerAttributesResponse::loadBalancerAttributes))
            .setter(setter(Builder::loadBalancerAttributes)).constructor(LoadBalancerAttributes::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LoadBalancerAttributes").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LOAD_BALANCER_NAME_FIELD,
            LOAD_BALANCER_ATTRIBUTES_FIELD));

    private final String loadBalancerName;

    private final LoadBalancerAttributes loadBalancerAttributes;

    private ModifyLoadBalancerAttributesResponse(BuilderImpl builder) {
        super(builder);
        this.loadBalancerName = builder.loadBalancerName;
        this.loadBalancerAttributes = builder.loadBalancerAttributes;
    }

    /**
     * <p>
     * The name of the load balancer.
     * </p>
     * 
     * @return The name of the load balancer.
     */
    public String loadBalancerName() {
        return loadBalancerName;
    }

    /**
     * <p>
     * Information about the load balancer attributes.
     * </p>
     * 
     * @return Information about the load balancer attributes.
     */
    public LoadBalancerAttributes loadBalancerAttributes() {
        return loadBalancerAttributes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(loadBalancerName());
        hashCode = 31 * hashCode + Objects.hashCode(loadBalancerAttributes());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModifyLoadBalancerAttributesResponse)) {
            return false;
        }
        ModifyLoadBalancerAttributesResponse other = (ModifyLoadBalancerAttributesResponse) obj;
        return Objects.equals(loadBalancerName(), other.loadBalancerName())
                && Objects.equals(loadBalancerAttributes(), other.loadBalancerAttributes());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ModifyLoadBalancerAttributesResponse").add("LoadBalancerName", loadBalancerName())
                .add("LoadBalancerAttributes", loadBalancerAttributes()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "LoadBalancerName":
            return Optional.ofNullable(clazz.cast(loadBalancerName()));
        case "LoadBalancerAttributes":
            return Optional.ofNullable(clazz.cast(loadBalancerAttributes()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ModifyLoadBalancerAttributesResponse, T> g) {
        return obj -> g.apply((ModifyLoadBalancerAttributesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ElasticLoadBalancingResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ModifyLoadBalancerAttributesResponse> {
        /**
         * <p>
         * The name of the load balancer.
         * </p>
         * 
         * @param loadBalancerName
         *        The name of the load balancer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder loadBalancerName(String loadBalancerName);

        /**
         * <p>
         * Information about the load balancer attributes.
         * </p>
         * 
         * @param loadBalancerAttributes
         *        Information about the load balancer attributes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder loadBalancerAttributes(LoadBalancerAttributes loadBalancerAttributes);

        /**
         * <p>
         * Information about the load balancer attributes.
         * </p>
         * This is a convenience that creates an instance of the {@link LoadBalancerAttributes.Builder} avoiding the
         * need to create one manually via {@link LoadBalancerAttributes#builder()}.
         *
         * When the {@link Consumer} completes, {@link LoadBalancerAttributes.Builder#build()} is called immediately and
         * its result is passed to {@link #loadBalancerAttributes(LoadBalancerAttributes)}.
         * 
         * @param loadBalancerAttributes
         *        a consumer that will call methods on {@link LoadBalancerAttributes.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #loadBalancerAttributes(LoadBalancerAttributes)
         */
        default Builder loadBalancerAttributes(Consumer<LoadBalancerAttributes.Builder> loadBalancerAttributes) {
            return loadBalancerAttributes(LoadBalancerAttributes.builder().applyMutation(loadBalancerAttributes).build());
        }
    }

    static final class BuilderImpl extends ElasticLoadBalancingResponse.BuilderImpl implements Builder {
        private String loadBalancerName;

        private LoadBalancerAttributes loadBalancerAttributes;

        private BuilderImpl() {
        }

        private BuilderImpl(ModifyLoadBalancerAttributesResponse model) {
            super(model);
            loadBalancerName(model.loadBalancerName);
            loadBalancerAttributes(model.loadBalancerAttributes);
        }

        public final String getLoadBalancerName() {
            return loadBalancerName;
        }

        @Override
        public final Builder loadBalancerName(String loadBalancerName) {
            this.loadBalancerName = loadBalancerName;
            return this;
        }

        public final void setLoadBalancerName(String loadBalancerName) {
            this.loadBalancerName = loadBalancerName;
        }

        public final LoadBalancerAttributes.Builder getLoadBalancerAttributes() {
            return loadBalancerAttributes != null ? loadBalancerAttributes.toBuilder() : null;
        }

        @Override
        public final Builder loadBalancerAttributes(LoadBalancerAttributes loadBalancerAttributes) {
            this.loadBalancerAttributes = loadBalancerAttributes;
            return this;
        }

        public final void setLoadBalancerAttributes(LoadBalancerAttributes.BuilderImpl loadBalancerAttributes) {
            this.loadBalancerAttributes = loadBalancerAttributes != null ? loadBalancerAttributes.build() : null;
        }

        @Override
        public ModifyLoadBalancerAttributesResponse build() {
            return new ModifyLoadBalancerAttributesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
