/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.elasticloadbalancing.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about a health check.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class HealthCheck implements SdkPojo, Serializable, ToCopyableBuilder<HealthCheck.Builder, HealthCheck> {
    private static final SdkField<String> TARGET_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(HealthCheck::target)).setter(setter(Builder::target))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Target").build()).build();

    private static final SdkField<Integer> INTERVAL_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(HealthCheck::interval)).setter(setter(Builder::interval))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Interval").build()).build();

    private static final SdkField<Integer> TIMEOUT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(HealthCheck::timeout)).setter(setter(Builder::timeout))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Timeout").build()).build();

    private static final SdkField<Integer> UNHEALTHY_THRESHOLD_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(HealthCheck::unhealthyThreshold)).setter(setter(Builder::unhealthyThreshold))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UnhealthyThreshold").build())
            .build();

    private static final SdkField<Integer> HEALTHY_THRESHOLD_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(HealthCheck::healthyThreshold)).setter(setter(Builder::healthyThreshold))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HealthyThreshold").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TARGET_FIELD, INTERVAL_FIELD,
            TIMEOUT_FIELD, UNHEALTHY_THRESHOLD_FIELD, HEALTHY_THRESHOLD_FIELD));

    private static final long serialVersionUID = 1L;

    private final String target;

    private final Integer interval;

    private final Integer timeout;

    private final Integer unhealthyThreshold;

    private final Integer healthyThreshold;

    private HealthCheck(BuilderImpl builder) {
        this.target = builder.target;
        this.interval = builder.interval;
        this.timeout = builder.timeout;
        this.unhealthyThreshold = builder.unhealthyThreshold;
        this.healthyThreshold = builder.healthyThreshold;
    }

    /**
     * <p>
     * The instance being checked. The protocol is either TCP, HTTP, HTTPS, or SSL. The range of valid ports is one (1)
     * through 65535.
     * </p>
     * <p>
     * TCP is the default, specified as a TCP: port pair, for example "TCP:5000". In this case, a health check simply
     * attempts to open a TCP connection to the instance on the specified port. Failure to connect within the configured
     * timeout is considered unhealthy.
     * </p>
     * <p>
     * SSL is also specified as SSL: port pair, for example, SSL:5000.
     * </p>
     * <p>
     * For HTTP/HTTPS, you must include a ping path in the string. HTTP is specified as a HTTP:port;/;PathToPing;
     * grouping, for example "HTTP:80/weather/us/wa/seattle". In this case, a HTTP GET request is issued to the instance
     * on the given port and path. Any answer other than "200 OK" within the timeout period is considered unhealthy.
     * </p>
     * <p>
     * The total length of the HTTP ping target must be 1024 16-bit Unicode characters or less.
     * </p>
     * 
     * @return The instance being checked. The protocol is either TCP, HTTP, HTTPS, or SSL. The range of valid ports is
     *         one (1) through 65535.</p>
     *         <p>
     *         TCP is the default, specified as a TCP: port pair, for example "TCP:5000". In this case, a health check
     *         simply attempts to open a TCP connection to the instance on the specified port. Failure to connect within
     *         the configured timeout is considered unhealthy.
     *         </p>
     *         <p>
     *         SSL is also specified as SSL: port pair, for example, SSL:5000.
     *         </p>
     *         <p>
     *         For HTTP/HTTPS, you must include a ping path in the string. HTTP is specified as a
     *         HTTP:port;/;PathToPing; grouping, for example "HTTP:80/weather/us/wa/seattle". In this case, a HTTP GET
     *         request is issued to the instance on the given port and path. Any answer other than "200 OK" within the
     *         timeout period is considered unhealthy.
     *         </p>
     *         <p>
     *         The total length of the HTTP ping target must be 1024 16-bit Unicode characters or less.
     */
    public String target() {
        return target;
    }

    /**
     * <p>
     * The approximate interval, in seconds, between health checks of an individual instance.
     * </p>
     * 
     * @return The approximate interval, in seconds, between health checks of an individual instance.
     */
    public Integer interval() {
        return interval;
    }

    /**
     * <p>
     * The amount of time, in seconds, during which no response means a failed health check.
     * </p>
     * <p>
     * This value must be less than the <code>Interval</code> value.
     * </p>
     * 
     * @return The amount of time, in seconds, during which no response means a failed health check.</p>
     *         <p>
     *         This value must be less than the <code>Interval</code> value.
     */
    public Integer timeout() {
        return timeout;
    }

    /**
     * <p>
     * The number of consecutive health check failures required before moving the instance to the <code>Unhealthy</code>
     * state.
     * </p>
     * 
     * @return The number of consecutive health check failures required before moving the instance to the
     *         <code>Unhealthy</code> state.
     */
    public Integer unhealthyThreshold() {
        return unhealthyThreshold;
    }

    /**
     * <p>
     * The number of consecutive health checks successes required before moving the instance to the <code>Healthy</code>
     * state.
     * </p>
     * 
     * @return The number of consecutive health checks successes required before moving the instance to the
     *         <code>Healthy</code> state.
     */
    public Integer healthyThreshold() {
        return healthyThreshold;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(target());
        hashCode = 31 * hashCode + Objects.hashCode(interval());
        hashCode = 31 * hashCode + Objects.hashCode(timeout());
        hashCode = 31 * hashCode + Objects.hashCode(unhealthyThreshold());
        hashCode = 31 * hashCode + Objects.hashCode(healthyThreshold());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof HealthCheck)) {
            return false;
        }
        HealthCheck other = (HealthCheck) obj;
        return Objects.equals(target(), other.target()) && Objects.equals(interval(), other.interval())
                && Objects.equals(timeout(), other.timeout()) && Objects.equals(unhealthyThreshold(), other.unhealthyThreshold())
                && Objects.equals(healthyThreshold(), other.healthyThreshold());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("HealthCheck").add("Target", target()).add("Interval", interval()).add("Timeout", timeout())
                .add("UnhealthyThreshold", unhealthyThreshold()).add("HealthyThreshold", healthyThreshold()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Target":
            return Optional.ofNullable(clazz.cast(target()));
        case "Interval":
            return Optional.ofNullable(clazz.cast(interval()));
        case "Timeout":
            return Optional.ofNullable(clazz.cast(timeout()));
        case "UnhealthyThreshold":
            return Optional.ofNullable(clazz.cast(unhealthyThreshold()));
        case "HealthyThreshold":
            return Optional.ofNullable(clazz.cast(healthyThreshold()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<HealthCheck, T> g) {
        return obj -> g.apply((HealthCheck) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, HealthCheck> {
        /**
         * <p>
         * The instance being checked. The protocol is either TCP, HTTP, HTTPS, or SSL. The range of valid ports is one
         * (1) through 65535.
         * </p>
         * <p>
         * TCP is the default, specified as a TCP: port pair, for example "TCP:5000". In this case, a health check
         * simply attempts to open a TCP connection to the instance on the specified port. Failure to connect within the
         * configured timeout is considered unhealthy.
         * </p>
         * <p>
         * SSL is also specified as SSL: port pair, for example, SSL:5000.
         * </p>
         * <p>
         * For HTTP/HTTPS, you must include a ping path in the string. HTTP is specified as a HTTP:port;/;PathToPing;
         * grouping, for example "HTTP:80/weather/us/wa/seattle". In this case, a HTTP GET request is issued to the
         * instance on the given port and path. Any answer other than "200 OK" within the timeout period is considered
         * unhealthy.
         * </p>
         * <p>
         * The total length of the HTTP ping target must be 1024 16-bit Unicode characters or less.
         * </p>
         * 
         * @param target
         *        The instance being checked. The protocol is either TCP, HTTP, HTTPS, or SSL. The range of valid ports
         *        is one (1) through 65535.</p>
         *        <p>
         *        TCP is the default, specified as a TCP: port pair, for example "TCP:5000". In this case, a health
         *        check simply attempts to open a TCP connection to the instance on the specified port. Failure to
         *        connect within the configured timeout is considered unhealthy.
         *        </p>
         *        <p>
         *        SSL is also specified as SSL: port pair, for example, SSL:5000.
         *        </p>
         *        <p>
         *        For HTTP/HTTPS, you must include a ping path in the string. HTTP is specified as a
         *        HTTP:port;/;PathToPing; grouping, for example "HTTP:80/weather/us/wa/seattle". In this case, a HTTP
         *        GET request is issued to the instance on the given port and path. Any answer other than "200 OK"
         *        within the timeout period is considered unhealthy.
         *        </p>
         *        <p>
         *        The total length of the HTTP ping target must be 1024 16-bit Unicode characters or less.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder target(String target);

        /**
         * <p>
         * The approximate interval, in seconds, between health checks of an individual instance.
         * </p>
         * 
         * @param interval
         *        The approximate interval, in seconds, between health checks of an individual instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder interval(Integer interval);

        /**
         * <p>
         * The amount of time, in seconds, during which no response means a failed health check.
         * </p>
         * <p>
         * This value must be less than the <code>Interval</code> value.
         * </p>
         * 
         * @param timeout
         *        The amount of time, in seconds, during which no response means a failed health check.</p>
         *        <p>
         *        This value must be less than the <code>Interval</code> value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timeout(Integer timeout);

        /**
         * <p>
         * The number of consecutive health check failures required before moving the instance to the
         * <code>Unhealthy</code> state.
         * </p>
         * 
         * @param unhealthyThreshold
         *        The number of consecutive health check failures required before moving the instance to the
         *        <code>Unhealthy</code> state.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder unhealthyThreshold(Integer unhealthyThreshold);

        /**
         * <p>
         * The number of consecutive health checks successes required before moving the instance to the
         * <code>Healthy</code> state.
         * </p>
         * 
         * @param healthyThreshold
         *        The number of consecutive health checks successes required before moving the instance to the
         *        <code>Healthy</code> state.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder healthyThreshold(Integer healthyThreshold);
    }

    static final class BuilderImpl implements Builder {
        private String target;

        private Integer interval;

        private Integer timeout;

        private Integer unhealthyThreshold;

        private Integer healthyThreshold;

        private BuilderImpl() {
        }

        private BuilderImpl(HealthCheck model) {
            target(model.target);
            interval(model.interval);
            timeout(model.timeout);
            unhealthyThreshold(model.unhealthyThreshold);
            healthyThreshold(model.healthyThreshold);
        }

        public final String getTarget() {
            return target;
        }

        @Override
        public final Builder target(String target) {
            this.target = target;
            return this;
        }

        public final void setTarget(String target) {
            this.target = target;
        }

        public final Integer getInterval() {
            return interval;
        }

        @Override
        public final Builder interval(Integer interval) {
            this.interval = interval;
            return this;
        }

        public final void setInterval(Integer interval) {
            this.interval = interval;
        }

        public final Integer getTimeout() {
            return timeout;
        }

        @Override
        public final Builder timeout(Integer timeout) {
            this.timeout = timeout;
            return this;
        }

        public final void setTimeout(Integer timeout) {
            this.timeout = timeout;
        }

        public final Integer getUnhealthyThreshold() {
            return unhealthyThreshold;
        }

        @Override
        public final Builder unhealthyThreshold(Integer unhealthyThreshold) {
            this.unhealthyThreshold = unhealthyThreshold;
            return this;
        }

        public final void setUnhealthyThreshold(Integer unhealthyThreshold) {
            this.unhealthyThreshold = unhealthyThreshold;
        }

        public final Integer getHealthyThreshold() {
            return healthyThreshold;
        }

        @Override
        public final Builder healthyThreshold(Integer healthyThreshold) {
            this.healthyThreshold = healthyThreshold;
            return this;
        }

        public final void setHealthyThreshold(Integer healthyThreshold) {
            this.healthyThreshold = healthyThreshold;
        }

        @Override
        public HealthCheck build() {
            return new HealthCheck(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
