/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticloadbalancing.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.services.elasticloadbalancing.model.ElasticLoadBalancingResponse;
import software.amazon.awssdk.services.elasticloadbalancing.model.TagDescription;
import software.amazon.awssdk.services.elasticloadbalancing.model.TagDescriptionsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeTagsResponse
extends ElasticLoadBalancingResponse
implements ToCopyableBuilder<Builder, DescribeTagsResponse> {
    private final List<TagDescription> tagDescriptions;

    private DescribeTagsResponse(BuilderImpl builder) {
        super(builder);
        this.tagDescriptions = builder.tagDescriptions;
    }

    public List<TagDescription> tagDescriptions() {
        return this.tagDescriptions;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.tagDescriptions());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeTagsResponse)) {
            return false;
        }
        DescribeTagsResponse other = (DescribeTagsResponse)((Object)obj);
        return Objects.equals(this.tagDescriptions(), other.tagDescriptions());
    }

    public String toString() {
        return ToString.builder((String)"DescribeTagsResponse").add("TagDescriptions", this.tagDescriptions()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TagDescriptions": {
                return Optional.of(clazz.cast(this.tagDescriptions()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends ElasticLoadBalancingResponse.BuilderImpl
    implements Builder {
        private List<TagDescription> tagDescriptions;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeTagsResponse model) {
            this.tagDescriptions(model.tagDescriptions);
        }

        public final Collection<TagDescription.Builder> getTagDescriptions() {
            return this.tagDescriptions != null ? (Collection)this.tagDescriptions.stream().map(TagDescription::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tagDescriptions(Collection<TagDescription> tagDescriptions) {
            this.tagDescriptions = TagDescriptionsCopier.copy(tagDescriptions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tagDescriptions(TagDescription ... tagDescriptions) {
            this.tagDescriptions(Arrays.asList(tagDescriptions));
            return this;
        }

        public final void setTagDescriptions(Collection<TagDescription.BuilderImpl> tagDescriptions) {
            this.tagDescriptions = TagDescriptionsCopier.copyFromBuilder(tagDescriptions);
        }

        @Override
        public DescribeTagsResponse build() {
            return new DescribeTagsResponse(this);
        }
    }

    public static interface Builder
    extends ElasticLoadBalancingResponse.Builder,
    CopyableBuilder<Builder, DescribeTagsResponse> {
        public Builder tagDescriptions(Collection<TagDescription> var1);

        public Builder tagDescriptions(TagDescription ... var1);
    }
}

