/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticloadbalancing.paginators;

import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.NextPageFetcher;
import software.amazon.awssdk.core.pagination.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.SdkIterable;
import software.amazon.awssdk.services.elasticloadbalancing.ElasticLoadBalancingClient;
import software.amazon.awssdk.services.elasticloadbalancing.model.DescribeLoadBalancersRequest;
import software.amazon.awssdk.services.elasticloadbalancing.model.DescribeLoadBalancersResponse;
import software.amazon.awssdk.services.elasticloadbalancing.model.LoadBalancerDescription;

public final class DescribeLoadBalancersPaginator
implements SdkIterable<DescribeLoadBalancersResponse> {
    private final ElasticLoadBalancingClient client;
    private final DescribeLoadBalancersRequest firstRequest;
    private final NextPageFetcher nextPageFetcher;

    public DescribeLoadBalancersPaginator(ElasticLoadBalancingClient client, DescribeLoadBalancersRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new DescribeLoadBalancersResponseFetcher();
    }

    public Iterator<DescribeLoadBalancersResponse> iterator() {
        return new PaginatedResponsesIterator(this.nextPageFetcher);
    }

    public SdkIterable<LoadBalancerDescription> loadBalancerDescriptions() {
        Function<DescribeLoadBalancersResponse, Iterator> getIterator = response -> response != null ? response.loadBalancerDescriptions().iterator() : null;
        return new PaginatedItemsIterable((SdkIterable)this, getIterator);
    }

    private class DescribeLoadBalancersResponseFetcher
    implements NextPageFetcher<DescribeLoadBalancersResponse> {
        private DescribeLoadBalancersResponseFetcher() {
        }

        public boolean hasNextPage(DescribeLoadBalancersResponse previousPage) {
            return previousPage.nextMarker() != null;
        }

        public DescribeLoadBalancersResponse nextPage(DescribeLoadBalancersResponse previousPage) {
            if (previousPage == null) {
                return DescribeLoadBalancersPaginator.this.client.describeLoadBalancers(DescribeLoadBalancersPaginator.this.firstRequest);
            }
            return DescribeLoadBalancersPaginator.this.client.describeLoadBalancers((DescribeLoadBalancersRequest)((Object)DescribeLoadBalancersPaginator.this.firstRequest.toBuilder().marker(previousPage.nextMarker()).build()));
        }
    }
}

