/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticloadbalancing.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.services.elasticloadbalancing.model.Listener;
import software.amazon.awssdk.services.elasticloadbalancing.model.PolicyNamesCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ListenerDescription
implements ToCopyableBuilder<Builder, ListenerDescription> {
    private final Listener listener;
    private final List<String> policyNames;

    private ListenerDescription(BuilderImpl builder) {
        this.listener = builder.listener;
        this.policyNames = builder.policyNames;
    }

    public Listener listener() {
        return this.listener;
    }

    public List<String> policyNames() {
        return this.policyNames;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.listener());
        hashCode = 31 * hashCode + Objects.hashCode(this.policyNames());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListenerDescription)) {
            return false;
        }
        ListenerDescription other = (ListenerDescription)obj;
        return Objects.equals(this.listener(), other.listener()) && Objects.equals(this.policyNames(), other.policyNames());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.listener() != null) {
            sb.append("Listener: ").append(this.listener()).append(",");
        }
        if (this.policyNames() != null) {
            sb.append("PolicyNames: ").append(this.policyNames()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Listener": {
                return Optional.of(clazz.cast(this.listener()));
            }
            case "PolicyNames": {
                return Optional.of(clazz.cast(this.policyNames()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private Listener listener;
        private List<String> policyNames;

        private BuilderImpl() {
        }

        private BuilderImpl(ListenerDescription model) {
            this.listener(model.listener);
            this.policyNames(model.policyNames);
        }

        public final Listener.Builder getListener() {
            return this.listener != null ? this.listener.toBuilder() : null;
        }

        @Override
        public final Builder listener(Listener listener) {
            this.listener = listener;
            return this;
        }

        public final void setListener(Listener.BuilderImpl listener) {
            this.listener = listener != null ? listener.build() : null;
        }

        public final Collection<String> getPolicyNames() {
            return this.policyNames;
        }

        @Override
        public final Builder policyNames(Collection<String> policyNames) {
            this.policyNames = PolicyNamesCopier.copy(policyNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder policyNames(String ... policyNames) {
            this.policyNames(Arrays.asList(policyNames));
            return this;
        }

        public final void setPolicyNames(Collection<String> policyNames) {
            this.policyNames = PolicyNamesCopier.copy(policyNames);
        }

        public ListenerDescription build() {
            return new ListenerDescription(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ListenerDescription> {
        public Builder listener(Listener var1);

        default public Builder listener(Consumer<Listener.Builder> listener) {
            return this.listener((Listener)((Listener.Builder)Listener.builder().apply(listener)).build());
        }

        public Builder policyNames(Collection<String> var1);

        public Builder policyNames(String ... var1);
    }
}

