/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticloadbalancing.transform;

import javax.xml.stream.events.XMLEvent;
import software.amazon.awssdk.core.runtime.transform.SimpleTypeStaxUnmarshallers;
import software.amazon.awssdk.core.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.elasticloadbalancing.model.Listener;

public class ListenerUnmarshaller
implements Unmarshaller<Listener, StaxUnmarshallerContext> {
    private static final ListenerUnmarshaller INSTANCE = new ListenerUnmarshaller();

    public Listener unmarshall(StaxUnmarshallerContext context) throws Exception {
        XMLEvent xmlEvent;
        Listener.Builder listener = Listener.builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (!(xmlEvent = context.nextEvent()).isEndDocument()) {
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("Protocol", targetDepth)) {
                    listener.protocol(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("LoadBalancerPort", targetDepth)) {
                    listener.loadBalancerPort(SimpleTypeStaxUnmarshallers.IntegerUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("InstanceProtocol", targetDepth)) {
                    listener.instanceProtocol(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("InstancePort", targetDepth)) {
                    listener.instancePort(SimpleTypeStaxUnmarshallers.IntegerUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("SSLCertificateId", targetDepth)) continue;
                listener.sslCertificateId(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (!xmlEvent.isEndElement() || context.getCurrentDepth() >= originalDepth) continue;
            break;
        }
        return (Listener)listener.build();
    }

    public static ListenerUnmarshaller getInstance() {
        return INSTANCE;
    }
}

