/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticloadbalancing.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.services.elasticloadbalancing.model.AvailabilityZonesCopier;
import software.amazon.awssdk.services.elasticloadbalancing.model.BackendServerDescription;
import software.amazon.awssdk.services.elasticloadbalancing.model.BackendServerDescriptionsCopier;
import software.amazon.awssdk.services.elasticloadbalancing.model.HealthCheck;
import software.amazon.awssdk.services.elasticloadbalancing.model.Instance;
import software.amazon.awssdk.services.elasticloadbalancing.model.InstancesCopier;
import software.amazon.awssdk.services.elasticloadbalancing.model.ListenerDescription;
import software.amazon.awssdk.services.elasticloadbalancing.model.ListenerDescriptionsCopier;
import software.amazon.awssdk.services.elasticloadbalancing.model.Policies;
import software.amazon.awssdk.services.elasticloadbalancing.model.SecurityGroupsCopier;
import software.amazon.awssdk.services.elasticloadbalancing.model.SourceSecurityGroup;
import software.amazon.awssdk.services.elasticloadbalancing.model.SubnetsCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class LoadBalancerDescription
implements ToCopyableBuilder<Builder, LoadBalancerDescription> {
    private final String loadBalancerName;
    private final String dnsName;
    private final String canonicalHostedZoneName;
    private final String canonicalHostedZoneNameID;
    private final List<ListenerDescription> listenerDescriptions;
    private final Policies policies;
    private final List<BackendServerDescription> backendServerDescriptions;
    private final List<String> availabilityZones;
    private final List<String> subnets;
    private final String vpcId;
    private final List<Instance> instances;
    private final HealthCheck healthCheck;
    private final SourceSecurityGroup sourceSecurityGroup;
    private final List<String> securityGroups;
    private final Instant createdTime;
    private final String scheme;

    private LoadBalancerDescription(BuilderImpl builder) {
        this.loadBalancerName = builder.loadBalancerName;
        this.dnsName = builder.dnsName;
        this.canonicalHostedZoneName = builder.canonicalHostedZoneName;
        this.canonicalHostedZoneNameID = builder.canonicalHostedZoneNameID;
        this.listenerDescriptions = builder.listenerDescriptions;
        this.policies = builder.policies;
        this.backendServerDescriptions = builder.backendServerDescriptions;
        this.availabilityZones = builder.availabilityZones;
        this.subnets = builder.subnets;
        this.vpcId = builder.vpcId;
        this.instances = builder.instances;
        this.healthCheck = builder.healthCheck;
        this.sourceSecurityGroup = builder.sourceSecurityGroup;
        this.securityGroups = builder.securityGroups;
        this.createdTime = builder.createdTime;
        this.scheme = builder.scheme;
    }

    public String loadBalancerName() {
        return this.loadBalancerName;
    }

    public String dnsName() {
        return this.dnsName;
    }

    public String canonicalHostedZoneName() {
        return this.canonicalHostedZoneName;
    }

    public String canonicalHostedZoneNameID() {
        return this.canonicalHostedZoneNameID;
    }

    public List<ListenerDescription> listenerDescriptions() {
        return this.listenerDescriptions;
    }

    public Policies policies() {
        return this.policies;
    }

    public List<BackendServerDescription> backendServerDescriptions() {
        return this.backendServerDescriptions;
    }

    public List<String> availabilityZones() {
        return this.availabilityZones;
    }

    public List<String> subnets() {
        return this.subnets;
    }

    public String vpcId() {
        return this.vpcId;
    }

    public List<Instance> instances() {
        return this.instances;
    }

    public HealthCheck healthCheck() {
        return this.healthCheck;
    }

    public SourceSecurityGroup sourceSecurityGroup() {
        return this.sourceSecurityGroup;
    }

    public List<String> securityGroups() {
        return this.securityGroups;
    }

    public Instant createdTime() {
        return this.createdTime;
    }

    public String scheme() {
        return this.scheme;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.loadBalancerName() == null ? 0 : this.loadBalancerName().hashCode());
        hashCode = 31 * hashCode + (this.dnsName() == null ? 0 : this.dnsName().hashCode());
        hashCode = 31 * hashCode + (this.canonicalHostedZoneName() == null ? 0 : this.canonicalHostedZoneName().hashCode());
        hashCode = 31 * hashCode + (this.canonicalHostedZoneNameID() == null ? 0 : this.canonicalHostedZoneNameID().hashCode());
        hashCode = 31 * hashCode + (this.listenerDescriptions() == null ? 0 : this.listenerDescriptions().hashCode());
        hashCode = 31 * hashCode + (this.policies() == null ? 0 : this.policies().hashCode());
        hashCode = 31 * hashCode + (this.backendServerDescriptions() == null ? 0 : this.backendServerDescriptions().hashCode());
        hashCode = 31 * hashCode + (this.availabilityZones() == null ? 0 : this.availabilityZones().hashCode());
        hashCode = 31 * hashCode + (this.subnets() == null ? 0 : this.subnets().hashCode());
        hashCode = 31 * hashCode + (this.vpcId() == null ? 0 : this.vpcId().hashCode());
        hashCode = 31 * hashCode + (this.instances() == null ? 0 : this.instances().hashCode());
        hashCode = 31 * hashCode + (this.healthCheck() == null ? 0 : this.healthCheck().hashCode());
        hashCode = 31 * hashCode + (this.sourceSecurityGroup() == null ? 0 : this.sourceSecurityGroup().hashCode());
        hashCode = 31 * hashCode + (this.securityGroups() == null ? 0 : this.securityGroups().hashCode());
        hashCode = 31 * hashCode + (this.createdTime() == null ? 0 : this.createdTime().hashCode());
        hashCode = 31 * hashCode + (this.scheme() == null ? 0 : this.scheme().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LoadBalancerDescription)) {
            return false;
        }
        LoadBalancerDescription other = (LoadBalancerDescription)obj;
        if (other.loadBalancerName() == null ^ this.loadBalancerName() == null) {
            return false;
        }
        if (other.loadBalancerName() != null && !other.loadBalancerName().equals(this.loadBalancerName())) {
            return false;
        }
        if (other.dnsName() == null ^ this.dnsName() == null) {
            return false;
        }
        if (other.dnsName() != null && !other.dnsName().equals(this.dnsName())) {
            return false;
        }
        if (other.canonicalHostedZoneName() == null ^ this.canonicalHostedZoneName() == null) {
            return false;
        }
        if (other.canonicalHostedZoneName() != null && !other.canonicalHostedZoneName().equals(this.canonicalHostedZoneName())) {
            return false;
        }
        if (other.canonicalHostedZoneNameID() == null ^ this.canonicalHostedZoneNameID() == null) {
            return false;
        }
        if (other.canonicalHostedZoneNameID() != null && !other.canonicalHostedZoneNameID().equals(this.canonicalHostedZoneNameID())) {
            return false;
        }
        if (other.listenerDescriptions() == null ^ this.listenerDescriptions() == null) {
            return false;
        }
        if (other.listenerDescriptions() != null && !other.listenerDescriptions().equals(this.listenerDescriptions())) {
            return false;
        }
        if (other.policies() == null ^ this.policies() == null) {
            return false;
        }
        if (other.policies() != null && !other.policies().equals(this.policies())) {
            return false;
        }
        if (other.backendServerDescriptions() == null ^ this.backendServerDescriptions() == null) {
            return false;
        }
        if (other.backendServerDescriptions() != null && !other.backendServerDescriptions().equals(this.backendServerDescriptions())) {
            return false;
        }
        if (other.availabilityZones() == null ^ this.availabilityZones() == null) {
            return false;
        }
        if (other.availabilityZones() != null && !other.availabilityZones().equals(this.availabilityZones())) {
            return false;
        }
        if (other.subnets() == null ^ this.subnets() == null) {
            return false;
        }
        if (other.subnets() != null && !other.subnets().equals(this.subnets())) {
            return false;
        }
        if (other.vpcId() == null ^ this.vpcId() == null) {
            return false;
        }
        if (other.vpcId() != null && !other.vpcId().equals(this.vpcId())) {
            return false;
        }
        if (other.instances() == null ^ this.instances() == null) {
            return false;
        }
        if (other.instances() != null && !other.instances().equals(this.instances())) {
            return false;
        }
        if (other.healthCheck() == null ^ this.healthCheck() == null) {
            return false;
        }
        if (other.healthCheck() != null && !other.healthCheck().equals(this.healthCheck())) {
            return false;
        }
        if (other.sourceSecurityGroup() == null ^ this.sourceSecurityGroup() == null) {
            return false;
        }
        if (other.sourceSecurityGroup() != null && !other.sourceSecurityGroup().equals(this.sourceSecurityGroup())) {
            return false;
        }
        if (other.securityGroups() == null ^ this.securityGroups() == null) {
            return false;
        }
        if (other.securityGroups() != null && !other.securityGroups().equals(this.securityGroups())) {
            return false;
        }
        if (other.createdTime() == null ^ this.createdTime() == null) {
            return false;
        }
        if (other.createdTime() != null && !other.createdTime().equals(this.createdTime())) {
            return false;
        }
        if (other.scheme() == null ^ this.scheme() == null) {
            return false;
        }
        return other.scheme() == null || other.scheme().equals(this.scheme());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.loadBalancerName() != null) {
            sb.append("LoadBalancerName: ").append(this.loadBalancerName()).append(",");
        }
        if (this.dnsName() != null) {
            sb.append("DNSName: ").append(this.dnsName()).append(",");
        }
        if (this.canonicalHostedZoneName() != null) {
            sb.append("CanonicalHostedZoneName: ").append(this.canonicalHostedZoneName()).append(",");
        }
        if (this.canonicalHostedZoneNameID() != null) {
            sb.append("CanonicalHostedZoneNameID: ").append(this.canonicalHostedZoneNameID()).append(",");
        }
        if (this.listenerDescriptions() != null) {
            sb.append("ListenerDescriptions: ").append(this.listenerDescriptions()).append(",");
        }
        if (this.policies() != null) {
            sb.append("Policies: ").append(this.policies()).append(",");
        }
        if (this.backendServerDescriptions() != null) {
            sb.append("BackendServerDescriptions: ").append(this.backendServerDescriptions()).append(",");
        }
        if (this.availabilityZones() != null) {
            sb.append("AvailabilityZones: ").append(this.availabilityZones()).append(",");
        }
        if (this.subnets() != null) {
            sb.append("Subnets: ").append(this.subnets()).append(",");
        }
        if (this.vpcId() != null) {
            sb.append("VPCId: ").append(this.vpcId()).append(",");
        }
        if (this.instances() != null) {
            sb.append("Instances: ").append(this.instances()).append(",");
        }
        if (this.healthCheck() != null) {
            sb.append("HealthCheck: ").append(this.healthCheck()).append(",");
        }
        if (this.sourceSecurityGroup() != null) {
            sb.append("SourceSecurityGroup: ").append(this.sourceSecurityGroup()).append(",");
        }
        if (this.securityGroups() != null) {
            sb.append("SecurityGroups: ").append(this.securityGroups()).append(",");
        }
        if (this.createdTime() != null) {
            sb.append("CreatedTime: ").append(this.createdTime()).append(",");
        }
        if (this.scheme() != null) {
            sb.append("Scheme: ").append(this.scheme()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "LoadBalancerName": {
                return Optional.of(clazz.cast(this.loadBalancerName()));
            }
            case "DNSName": {
                return Optional.of(clazz.cast(this.dnsName()));
            }
            case "CanonicalHostedZoneName": {
                return Optional.of(clazz.cast(this.canonicalHostedZoneName()));
            }
            case "CanonicalHostedZoneNameID": {
                return Optional.of(clazz.cast(this.canonicalHostedZoneNameID()));
            }
            case "ListenerDescriptions": {
                return Optional.of(clazz.cast(this.listenerDescriptions()));
            }
            case "Policies": {
                return Optional.of(clazz.cast(this.policies()));
            }
            case "BackendServerDescriptions": {
                return Optional.of(clazz.cast(this.backendServerDescriptions()));
            }
            case "AvailabilityZones": {
                return Optional.of(clazz.cast(this.availabilityZones()));
            }
            case "Subnets": {
                return Optional.of(clazz.cast(this.subnets()));
            }
            case "VPCId": {
                return Optional.of(clazz.cast(this.vpcId()));
            }
            case "Instances": {
                return Optional.of(clazz.cast(this.instances()));
            }
            case "HealthCheck": {
                return Optional.of(clazz.cast(this.healthCheck()));
            }
            case "SourceSecurityGroup": {
                return Optional.of(clazz.cast(this.sourceSecurityGroup()));
            }
            case "SecurityGroups": {
                return Optional.of(clazz.cast(this.securityGroups()));
            }
            case "CreatedTime": {
                return Optional.of(clazz.cast(this.createdTime()));
            }
            case "Scheme": {
                return Optional.of(clazz.cast(this.scheme()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String loadBalancerName;
        private String dnsName;
        private String canonicalHostedZoneName;
        private String canonicalHostedZoneNameID;
        private List<ListenerDescription> listenerDescriptions;
        private Policies policies;
        private List<BackendServerDescription> backendServerDescriptions;
        private List<String> availabilityZones;
        private List<String> subnets;
        private String vpcId;
        private List<Instance> instances;
        private HealthCheck healthCheck;
        private SourceSecurityGroup sourceSecurityGroup;
        private List<String> securityGroups;
        private Instant createdTime;
        private String scheme;

        private BuilderImpl() {
        }

        private BuilderImpl(LoadBalancerDescription model) {
            this.loadBalancerName(model.loadBalancerName);
            this.dnsName(model.dnsName);
            this.canonicalHostedZoneName(model.canonicalHostedZoneName);
            this.canonicalHostedZoneNameID(model.canonicalHostedZoneNameID);
            this.listenerDescriptions(model.listenerDescriptions);
            this.policies(model.policies);
            this.backendServerDescriptions(model.backendServerDescriptions);
            this.availabilityZones(model.availabilityZones);
            this.subnets(model.subnets);
            this.vpcId(model.vpcId);
            this.instances(model.instances);
            this.healthCheck(model.healthCheck);
            this.sourceSecurityGroup(model.sourceSecurityGroup);
            this.securityGroups(model.securityGroups);
            this.createdTime(model.createdTime);
            this.scheme(model.scheme);
        }

        public final String getLoadBalancerName() {
            return this.loadBalancerName;
        }

        @Override
        public final Builder loadBalancerName(String loadBalancerName) {
            this.loadBalancerName = loadBalancerName;
            return this;
        }

        public final void setLoadBalancerName(String loadBalancerName) {
            this.loadBalancerName = loadBalancerName;
        }

        public final String getDNSName() {
            return this.dnsName;
        }

        @Override
        public final Builder dnsName(String dnsName) {
            this.dnsName = dnsName;
            return this;
        }

        public final void setDNSName(String dnsName) {
            this.dnsName = dnsName;
        }

        public final String getCanonicalHostedZoneName() {
            return this.canonicalHostedZoneName;
        }

        @Override
        public final Builder canonicalHostedZoneName(String canonicalHostedZoneName) {
            this.canonicalHostedZoneName = canonicalHostedZoneName;
            return this;
        }

        public final void setCanonicalHostedZoneName(String canonicalHostedZoneName) {
            this.canonicalHostedZoneName = canonicalHostedZoneName;
        }

        public final String getCanonicalHostedZoneNameID() {
            return this.canonicalHostedZoneNameID;
        }

        @Override
        public final Builder canonicalHostedZoneNameID(String canonicalHostedZoneNameID) {
            this.canonicalHostedZoneNameID = canonicalHostedZoneNameID;
            return this;
        }

        public final void setCanonicalHostedZoneNameID(String canonicalHostedZoneNameID) {
            this.canonicalHostedZoneNameID = canonicalHostedZoneNameID;
        }

        public final Collection<ListenerDescription.Builder> getListenerDescriptions() {
            return this.listenerDescriptions != null ? (Collection)this.listenerDescriptions.stream().map(ListenerDescription::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder listenerDescriptions(Collection<ListenerDescription> listenerDescriptions) {
            this.listenerDescriptions = ListenerDescriptionsCopier.copy(listenerDescriptions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder listenerDescriptions(ListenerDescription ... listenerDescriptions) {
            this.listenerDescriptions(Arrays.asList(listenerDescriptions));
            return this;
        }

        public final void setListenerDescriptions(Collection<ListenerDescription.BuilderImpl> listenerDescriptions) {
            this.listenerDescriptions = ListenerDescriptionsCopier.copyFromBuilder(listenerDescriptions);
        }

        public final Policies.Builder getPolicies() {
            return this.policies != null ? this.policies.toBuilder() : null;
        }

        @Override
        public final Builder policies(Policies policies) {
            this.policies = policies;
            return this;
        }

        public final void setPolicies(Policies.BuilderImpl policies) {
            this.policies = policies != null ? policies.build() : null;
        }

        public final Collection<BackendServerDescription.Builder> getBackendServerDescriptions() {
            return this.backendServerDescriptions != null ? (Collection)this.backendServerDescriptions.stream().map(BackendServerDescription::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder backendServerDescriptions(Collection<BackendServerDescription> backendServerDescriptions) {
            this.backendServerDescriptions = BackendServerDescriptionsCopier.copy(backendServerDescriptions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder backendServerDescriptions(BackendServerDescription ... backendServerDescriptions) {
            this.backendServerDescriptions(Arrays.asList(backendServerDescriptions));
            return this;
        }

        public final void setBackendServerDescriptions(Collection<BackendServerDescription.BuilderImpl> backendServerDescriptions) {
            this.backendServerDescriptions = BackendServerDescriptionsCopier.copyFromBuilder(backendServerDescriptions);
        }

        public final Collection<String> getAvailabilityZones() {
            return this.availabilityZones;
        }

        @Override
        public final Builder availabilityZones(Collection<String> availabilityZones) {
            this.availabilityZones = AvailabilityZonesCopier.copy(availabilityZones);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder availabilityZones(String ... availabilityZones) {
            this.availabilityZones(Arrays.asList(availabilityZones));
            return this;
        }

        public final void setAvailabilityZones(Collection<String> availabilityZones) {
            this.availabilityZones = AvailabilityZonesCopier.copy(availabilityZones);
        }

        public final Collection<String> getSubnets() {
            return this.subnets;
        }

        @Override
        public final Builder subnets(Collection<String> subnets) {
            this.subnets = SubnetsCopier.copy(subnets);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder subnets(String ... subnets) {
            this.subnets(Arrays.asList(subnets));
            return this;
        }

        public final void setSubnets(Collection<String> subnets) {
            this.subnets = SubnetsCopier.copy(subnets);
        }

        public final String getVPCId() {
            return this.vpcId;
        }

        @Override
        public final Builder vpcId(String vpcId) {
            this.vpcId = vpcId;
            return this;
        }

        public final void setVPCId(String vpcId) {
            this.vpcId = vpcId;
        }

        public final Collection<Instance.Builder> getInstances() {
            return this.instances != null ? (Collection)this.instances.stream().map(Instance::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder instances(Collection<Instance> instances) {
            this.instances = InstancesCopier.copy(instances);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instances(Instance ... instances) {
            this.instances(Arrays.asList(instances));
            return this;
        }

        public final void setInstances(Collection<Instance.BuilderImpl> instances) {
            this.instances = InstancesCopier.copyFromBuilder(instances);
        }

        public final HealthCheck.Builder getHealthCheck() {
            return this.healthCheck != null ? this.healthCheck.toBuilder() : null;
        }

        @Override
        public final Builder healthCheck(HealthCheck healthCheck) {
            this.healthCheck = healthCheck;
            return this;
        }

        public final void setHealthCheck(HealthCheck.BuilderImpl healthCheck) {
            this.healthCheck = healthCheck != null ? healthCheck.build() : null;
        }

        public final SourceSecurityGroup.Builder getSourceSecurityGroup() {
            return this.sourceSecurityGroup != null ? this.sourceSecurityGroup.toBuilder() : null;
        }

        @Override
        public final Builder sourceSecurityGroup(SourceSecurityGroup sourceSecurityGroup) {
            this.sourceSecurityGroup = sourceSecurityGroup;
            return this;
        }

        public final void setSourceSecurityGroup(SourceSecurityGroup.BuilderImpl sourceSecurityGroup) {
            this.sourceSecurityGroup = sourceSecurityGroup != null ? sourceSecurityGroup.build() : null;
        }

        public final Collection<String> getSecurityGroups() {
            return this.securityGroups;
        }

        @Override
        public final Builder securityGroups(Collection<String> securityGroups) {
            this.securityGroups = SecurityGroupsCopier.copy(securityGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder securityGroups(String ... securityGroups) {
            this.securityGroups(Arrays.asList(securityGroups));
            return this;
        }

        public final void setSecurityGroups(Collection<String> securityGroups) {
            this.securityGroups = SecurityGroupsCopier.copy(securityGroups);
        }

        public final Instant getCreatedTime() {
            return this.createdTime;
        }

        @Override
        public final Builder createdTime(Instant createdTime) {
            this.createdTime = createdTime;
            return this;
        }

        public final void setCreatedTime(Instant createdTime) {
            this.createdTime = createdTime;
        }

        public final String getScheme() {
            return this.scheme;
        }

        @Override
        public final Builder scheme(String scheme) {
            this.scheme = scheme;
            return this;
        }

        public final void setScheme(String scheme) {
            this.scheme = scheme;
        }

        public LoadBalancerDescription build() {
            return new LoadBalancerDescription(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, LoadBalancerDescription> {
        public Builder loadBalancerName(String var1);

        public Builder dnsName(String var1);

        public Builder canonicalHostedZoneName(String var1);

        public Builder canonicalHostedZoneNameID(String var1);

        public Builder listenerDescriptions(Collection<ListenerDescription> var1);

        public Builder listenerDescriptions(ListenerDescription ... var1);

        public Builder policies(Policies var1);

        public Builder backendServerDescriptions(Collection<BackendServerDescription> var1);

        public Builder backendServerDescriptions(BackendServerDescription ... var1);

        public Builder availabilityZones(Collection<String> var1);

        public Builder availabilityZones(String ... var1);

        public Builder subnets(Collection<String> var1);

        public Builder subnets(String ... var1);

        public Builder vpcId(String var1);

        public Builder instances(Collection<Instance> var1);

        public Builder instances(Instance ... var1);

        public Builder healthCheck(HealthCheck var1);

        public Builder sourceSecurityGroup(SourceSecurityGroup var1);

        public Builder securityGroups(Collection<String> var1);

        public Builder securityGroups(String ... var1);

        public Builder createdTime(Instant var1);

        public Builder scheme(String var1);
    }
}

