/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticloadbalancing.waiters;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.services.elasticloadbalancing.ElasticLoadBalancingClient;
import software.amazon.awssdk.services.elasticloadbalancing.model.DescribeInstanceHealthRequest;
import software.amazon.awssdk.services.elasticloadbalancing.waiters.AnyInstanceInService;
import software.amazon.awssdk.services.elasticloadbalancing.waiters.DescribeInstanceHealthFunction;
import software.amazon.awssdk.services.elasticloadbalancing.waiters.InstanceDeregistered;
import software.amazon.awssdk.services.elasticloadbalancing.waiters.InstanceInService;
import software.amazon.awssdk.waiters.FixedDelayStrategy;
import software.amazon.awssdk.waiters.MaxAttemptsRetryStrategy;
import software.amazon.awssdk.waiters.PollingStrategy;
import software.amazon.awssdk.waiters.SdkFunction;
import software.amazon.awssdk.waiters.Waiter;
import software.amazon.awssdk.waiters.WaiterAcceptor;
import software.amazon.awssdk.waiters.WaiterBuilder;

public class ElasticLoadBalancingClientWaiters {
    private final ElasticLoadBalancingClient client;
    private final ExecutorService executorService = Executors.newFixedThreadPool(50);

    @SdkInternalApi
    public ElasticLoadBalancingClientWaiters(ElasticLoadBalancingClient client) {
        this.client = client;
    }

    public Waiter<DescribeInstanceHealthRequest> anyInstanceInService() {
        return new WaiterBuilder().withSdkFunction((SdkFunction)new DescribeInstanceHealthFunction(this.client)).withAcceptors(new WaiterAcceptor[]{new AnyInstanceInService.IsInServiceMatcher()}).withDefaultPollingStrategy(new PollingStrategy((PollingStrategy.RetryStrategy)new MaxAttemptsRetryStrategy(40), (PollingStrategy.DelayStrategy)new FixedDelayStrategy(15))).withExecutorService(this.executorService).build();
    }

    public Waiter<DescribeInstanceHealthRequest> instanceDeregistered() {
        return new WaiterBuilder().withSdkFunction((SdkFunction)new DescribeInstanceHealthFunction(this.client)).withAcceptors(new WaiterAcceptor[]{new InstanceDeregistered.IsOutOfServiceMatcher(), new InstanceDeregistered.IsInvalidInstanceMatcher()}).withDefaultPollingStrategy(new PollingStrategy((PollingStrategy.RetryStrategy)new MaxAttemptsRetryStrategy(40), (PollingStrategy.DelayStrategy)new FixedDelayStrategy(15))).withExecutorService(this.executorService).build();
    }

    public Waiter<DescribeInstanceHealthRequest> instanceInService() {
        return new WaiterBuilder().withSdkFunction((SdkFunction)new DescribeInstanceHealthFunction(this.client)).withAcceptors(new WaiterAcceptor[]{new InstanceInService.IsInServiceMatcher(), new InstanceInService.IsInvalidInstanceMatcher()}).withDefaultPollingStrategy(new PollingStrategy((PollingStrategy.RetryStrategy)new MaxAttemptsRetryStrategy(40), (PollingStrategy.DelayStrategy)new FixedDelayStrategy(15))).withExecutorService(this.executorService).build();
    }
}

