/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticloadbalancing.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.services.elasticloadbalancing.model.Tag;
import software.amazon.awssdk.services.elasticloadbalancing.model.TagListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class TagDescription
implements ToCopyableBuilder<Builder, TagDescription> {
    private final String loadBalancerName;
    private final List<Tag> tags;

    private TagDescription(BuilderImpl builder) {
        this.loadBalancerName = builder.loadBalancerName;
        this.tags = builder.tags;
    }

    public String loadBalancerName() {
        return this.loadBalancerName;
    }

    public List<Tag> tags() {
        return this.tags;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.loadBalancerName() == null ? 0 : this.loadBalancerName().hashCode());
        hashCode = 31 * hashCode + (this.tags() == null ? 0 : this.tags().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TagDescription)) {
            return false;
        }
        TagDescription other = (TagDescription)obj;
        if (other.loadBalancerName() == null ^ this.loadBalancerName() == null) {
            return false;
        }
        if (other.loadBalancerName() != null && !other.loadBalancerName().equals(this.loadBalancerName())) {
            return false;
        }
        if (other.tags() == null ^ this.tags() == null) {
            return false;
        }
        return other.tags() == null || other.tags().equals(this.tags());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.loadBalancerName() != null) {
            sb.append("LoadBalancerName: ").append(this.loadBalancerName()).append(",");
        }
        if (this.tags() != null) {
            sb.append("Tags: ").append(this.tags()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String loadBalancerName;
        private List<Tag> tags;

        private BuilderImpl() {
        }

        private BuilderImpl(TagDescription model) {
            this.setLoadBalancerName(model.loadBalancerName);
            this.setTags(model.tags);
        }

        public final String getLoadBalancerName() {
            return this.loadBalancerName;
        }

        @Override
        public final Builder loadBalancerName(String loadBalancerName) {
            this.loadBalancerName = loadBalancerName;
            return this;
        }

        public final void setLoadBalancerName(String loadBalancerName) {
            this.loadBalancerName = loadBalancerName;
        }

        public final Collection<Tag> getTags() {
            return this.tags;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        public final void setTags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
        }

        public TagDescription build() {
            return new TagDescription(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, TagDescription> {
        public Builder loadBalancerName(String var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);
    }
}

