/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticloadbalancing.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.services.elasticloadbalancing.model.Instance;
import software.amazon.awssdk.services.elasticloadbalancing.model.InstancesCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class RegisterInstancesWithLoadBalancerResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, RegisterInstancesWithLoadBalancerResponse> {
    private final List<Instance> instances;

    private RegisterInstancesWithLoadBalancerResponse(BuilderImpl builder) {
        this.instances = builder.instances;
    }

    public List<Instance> instances() {
        return this.instances;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.instances() == null ? 0 : this.instances().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RegisterInstancesWithLoadBalancerResponse)) {
            return false;
        }
        RegisterInstancesWithLoadBalancerResponse other = (RegisterInstancesWithLoadBalancerResponse)((Object)obj);
        if (other.instances() == null ^ this.instances() == null) {
            return false;
        }
        return other.instances() == null || other.instances().equals(this.instances());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.instances() != null) {
            sb.append("Instances: ").append(this.instances()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private List<Instance> instances;

        private BuilderImpl() {
        }

        private BuilderImpl(RegisterInstancesWithLoadBalancerResponse model) {
            this.setInstances(model.instances);
        }

        public final Collection<Instance> getInstances() {
            return this.instances;
        }

        @Override
        public final Builder instances(Collection<Instance> instances) {
            this.instances = InstancesCopier.copy(instances);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instances(Instance ... instances) {
            this.instances(Arrays.asList(instances));
            return this;
        }

        public final void setInstances(Collection<Instance> instances) {
            this.instances = InstancesCopier.copy(instances);
        }

        @SafeVarargs
        public final void setInstances(Instance ... instances) {
            this.instances(Arrays.asList(instances));
        }

        public RegisterInstancesWithLoadBalancerResponse build() {
            return new RegisterInstancesWithLoadBalancerResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, RegisterInstancesWithLoadBalancerResponse> {
        public Builder instances(Collection<Instance> var1);

        public Builder instances(Instance ... var1);
    }
}

