/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticloadbalancing.transform;

import java.util.List;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.elasticloadbalancing.model.EnableAvailabilityZonesForLoadBalancerRequest;

public class EnableAvailabilityZonesForLoadBalancerRequestMarshaller
implements Marshaller<Request<EnableAvailabilityZonesForLoadBalancerRequest>, EnableAvailabilityZonesForLoadBalancerRequest> {
    public Request<EnableAvailabilityZonesForLoadBalancerRequest> marshall(EnableAvailabilityZonesForLoadBalancerRequest enableAvailabilityZonesForLoadBalancerRequest) {
        if (enableAvailabilityZonesForLoadBalancerRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)enableAvailabilityZonesForLoadBalancerRequest, "ElasticLoadBalancingClient");
        request.addParameter("Action", "EnableAvailabilityZonesForLoadBalancer");
        request.addParameter("Version", "2012-06-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (enableAvailabilityZonesForLoadBalancerRequest.loadBalancerName() != null) {
            request.addParameter("LoadBalancerName", StringConversion.fromString((String)enableAvailabilityZonesForLoadBalancerRequest.loadBalancerName()));
        }
        if (enableAvailabilityZonesForLoadBalancerRequest.availabilityZones().isEmpty() && !(enableAvailabilityZonesForLoadBalancerRequest.availabilityZones() instanceof SdkAutoConstructList)) {
            request.addParameter("AvailabilityZones", "");
        } else if (!enableAvailabilityZonesForLoadBalancerRequest.availabilityZones().isEmpty() && !(enableAvailabilityZonesForLoadBalancerRequest.availabilityZones() instanceof SdkAutoConstructList)) {
            List<String> availabilityZonesList = enableAvailabilityZonesForLoadBalancerRequest.availabilityZones();
            int availabilityZonesListIndex = 1;
            for (String availabilityZonesListValue : availabilityZonesList) {
                if (availabilityZonesListValue != null) {
                    request.addParameter("AvailabilityZones.member." + availabilityZonesListIndex, StringConversion.fromString((String)availabilityZonesListValue));
                }
                ++availabilityZonesListIndex;
            }
        }
        return request;
    }
}

