/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticloadbalancing.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.elasticloadbalancing.model.ElasticLoadBalancingRequest;
import software.amazon.awssdk.services.elasticloadbalancing.model.PortsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DeleteLoadBalancerListenersRequest
extends ElasticLoadBalancingRequest
implements ToCopyableBuilder<Builder, DeleteLoadBalancerListenersRequest> {
    private final String loadBalancerName;
    private final List<Integer> loadBalancerPorts;

    private DeleteLoadBalancerListenersRequest(BuilderImpl builder) {
        super(builder);
        this.loadBalancerName = builder.loadBalancerName;
        this.loadBalancerPorts = builder.loadBalancerPorts;
    }

    public String loadBalancerName() {
        return this.loadBalancerName;
    }

    public List<Integer> loadBalancerPorts() {
        return this.loadBalancerPorts;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.loadBalancerName());
        hashCode = 31 * hashCode + Objects.hashCode(this.loadBalancerPorts());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteLoadBalancerListenersRequest)) {
            return false;
        }
        DeleteLoadBalancerListenersRequest other = (DeleteLoadBalancerListenersRequest)((Object)obj);
        return Objects.equals(this.loadBalancerName(), other.loadBalancerName()) && Objects.equals(this.loadBalancerPorts(), other.loadBalancerPorts());
    }

    public String toString() {
        return ToString.builder((String)"DeleteLoadBalancerListenersRequest").add("LoadBalancerName", (Object)this.loadBalancerName()).add("LoadBalancerPorts", this.loadBalancerPorts()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "LoadBalancerName": {
                return Optional.ofNullable(clazz.cast(this.loadBalancerName()));
            }
            case "LoadBalancerPorts": {
                return Optional.ofNullable(clazz.cast(this.loadBalancerPorts()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends ElasticLoadBalancingRequest.BuilderImpl
    implements Builder {
        private String loadBalancerName;
        private List<Integer> loadBalancerPorts = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteLoadBalancerListenersRequest model) {
            super(model);
            this.loadBalancerName(model.loadBalancerName);
            this.loadBalancerPorts(model.loadBalancerPorts);
        }

        public final String getLoadBalancerName() {
            return this.loadBalancerName;
        }

        @Override
        public final Builder loadBalancerName(String loadBalancerName) {
            this.loadBalancerName = loadBalancerName;
            return this;
        }

        public final void setLoadBalancerName(String loadBalancerName) {
            this.loadBalancerName = loadBalancerName;
        }

        public final Collection<Integer> getLoadBalancerPorts() {
            return this.loadBalancerPorts;
        }

        @Override
        public final Builder loadBalancerPorts(Collection<Integer> loadBalancerPorts) {
            this.loadBalancerPorts = PortsCopier.copy(loadBalancerPorts);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder loadBalancerPorts(Integer ... loadBalancerPorts) {
            this.loadBalancerPorts(Arrays.asList(loadBalancerPorts));
            return this;
        }

        public final void setLoadBalancerPorts(Collection<Integer> loadBalancerPorts) {
            this.loadBalancerPorts = PortsCopier.copy(loadBalancerPorts);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeleteLoadBalancerListenersRequest build() {
            return new DeleteLoadBalancerListenersRequest(this);
        }
    }

    public static interface Builder
    extends ElasticLoadBalancingRequest.Builder,
    CopyableBuilder<Builder, DeleteLoadBalancerListenersRequest> {
        public Builder loadBalancerName(String var1);

        public Builder loadBalancerPorts(Collection<Integer> var1);

        public Builder loadBalancerPorts(Integer ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

