/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticloadbalancing.transform;

import java.util.List;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.elasticloadbalancing.model.DescribeLoadBalancerPoliciesRequest;

public class DescribeLoadBalancerPoliciesRequestMarshaller
implements Marshaller<Request<DescribeLoadBalancerPoliciesRequest>, DescribeLoadBalancerPoliciesRequest> {
    public Request<DescribeLoadBalancerPoliciesRequest> marshall(DescribeLoadBalancerPoliciesRequest describeLoadBalancerPoliciesRequest) {
        if (describeLoadBalancerPoliciesRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)describeLoadBalancerPoliciesRequest, "ElasticLoadBalancingClient");
        request.addParameter("Action", "DescribeLoadBalancerPolicies");
        request.addParameter("Version", "2012-06-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (describeLoadBalancerPoliciesRequest.loadBalancerName() != null) {
            request.addParameter("LoadBalancerName", StringConversion.fromString((String)describeLoadBalancerPoliciesRequest.loadBalancerName()));
        }
        if (describeLoadBalancerPoliciesRequest.policyNames().isEmpty() && !(describeLoadBalancerPoliciesRequest.policyNames() instanceof SdkAutoConstructList)) {
            request.addParameter("PolicyNames", "");
        } else if (!describeLoadBalancerPoliciesRequest.policyNames().isEmpty() && !(describeLoadBalancerPoliciesRequest.policyNames() instanceof SdkAutoConstructList)) {
            List<String> policyNamesList = describeLoadBalancerPoliciesRequest.policyNames();
            int policyNamesListIndex = 1;
            for (String policyNamesListValue : policyNamesList) {
                if (policyNamesListValue != null) {
                    request.addParameter("PolicyNames.member." + policyNamesListIndex, StringConversion.fromString((String)policyNamesListValue));
                }
                ++policyNamesListIndex;
            }
        }
        return request;
    }
}

