/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticloadbalancing.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.elasticloadbalancing.model.ElasticLoadBalancingRequest;
import software.amazon.awssdk.services.elasticloadbalancing.model.PolicyTypeNamesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeLoadBalancerPolicyTypesRequest
extends ElasticLoadBalancingRequest
implements ToCopyableBuilder<Builder, DescribeLoadBalancerPolicyTypesRequest> {
    private final List<String> policyTypeNames;

    private DescribeLoadBalancerPolicyTypesRequest(BuilderImpl builder) {
        super(builder);
        this.policyTypeNames = builder.policyTypeNames;
    }

    public List<String> policyTypeNames() {
        return this.policyTypeNames;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.policyTypeNames());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeLoadBalancerPolicyTypesRequest)) {
            return false;
        }
        DescribeLoadBalancerPolicyTypesRequest other = (DescribeLoadBalancerPolicyTypesRequest)((Object)obj);
        return Objects.equals(this.policyTypeNames(), other.policyTypeNames());
    }

    public String toString() {
        return ToString.builder((String)"DescribeLoadBalancerPolicyTypesRequest").add("PolicyTypeNames", this.policyTypeNames()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "PolicyTypeNames": {
                return Optional.of(clazz.cast(this.policyTypeNames()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends ElasticLoadBalancingRequest.BuilderImpl
    implements Builder {
        private List<String> policyTypeNames;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeLoadBalancerPolicyTypesRequest model) {
            super(model);
            this.policyTypeNames(model.policyTypeNames);
        }

        public final Collection<String> getPolicyTypeNames() {
            return this.policyTypeNames;
        }

        @Override
        public final Builder policyTypeNames(Collection<String> policyTypeNames) {
            this.policyTypeNames = PolicyTypeNamesCopier.copy(policyTypeNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder policyTypeNames(String ... policyTypeNames) {
            this.policyTypeNames(Arrays.asList(policyTypeNames));
            return this;
        }

        public final void setPolicyTypeNames(Collection<String> policyTypeNames) {
            this.policyTypeNames = PolicyTypeNamesCopier.copy(policyTypeNames);
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public DescribeLoadBalancerPolicyTypesRequest build() {
            return new DescribeLoadBalancerPolicyTypesRequest(this);
        }
    }

    public static interface Builder
    extends ElasticLoadBalancingRequest.Builder,
    CopyableBuilder<Builder, DescribeLoadBalancerPolicyTypesRequest> {
        public Builder policyTypeNames(Collection<String> var1);

        public Builder policyTypeNames(String ... var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> var1);
    }
}

