/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticloadbalancing.transform;

import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.runtime.SdkInternalList;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.services.elasticloadbalancing.model.DetachLoadBalancerFromSubnetsRequest;
import software.amazon.awssdk.util.StringUtils;

public class DetachLoadBalancerFromSubnetsRequestMarshaller
implements Marshaller<Request<DetachLoadBalancerFromSubnetsRequest>, DetachLoadBalancerFromSubnetsRequest> {
    public Request<DetachLoadBalancerFromSubnetsRequest> marshall(DetachLoadBalancerFromSubnetsRequest detachLoadBalancerFromSubnetsRequest) {
        SdkInternalList subnetsList;
        if (detachLoadBalancerFromSubnetsRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)detachLoadBalancerFromSubnetsRequest, "ElasticLoadBalancingClient");
        request.addParameter("Action", "DetachLoadBalancerFromSubnets");
        request.addParameter("Version", "2012-06-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (detachLoadBalancerFromSubnetsRequest.loadBalancerName() != null) {
            request.addParameter("LoadBalancerName", StringUtils.fromString((String)detachLoadBalancerFromSubnetsRequest.loadBalancerName()));
        }
        if (!(subnetsList = (SdkInternalList)detachLoadBalancerFromSubnetsRequest.subnets()).isEmpty() || !subnetsList.isAutoConstruct()) {
            int subnetsListIndex = 1;
            for (String subnetsListValue : subnetsList) {
                if (subnetsListValue != null) {
                    request.addParameter("Subnets.member." + subnetsListIndex, StringUtils.fromString((String)subnetsListValue));
                }
                ++subnetsListIndex;
            }
        }
        return request;
    }
}

