/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticloadbalancing.transform;

import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.runtime.SdkInternalList;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.services.elasticloadbalancing.model.DescribeLoadBalancerPolicyTypesRequest;
import software.amazon.awssdk.util.StringUtils;

public class DescribeLoadBalancerPolicyTypesRequestMarshaller
implements Marshaller<Request<DescribeLoadBalancerPolicyTypesRequest>, DescribeLoadBalancerPolicyTypesRequest> {
    public Request<DescribeLoadBalancerPolicyTypesRequest> marshall(DescribeLoadBalancerPolicyTypesRequest describeLoadBalancerPolicyTypesRequest) {
        if (describeLoadBalancerPolicyTypesRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)describeLoadBalancerPolicyTypesRequest, "ElasticLoadBalancingClient");
        request.addParameter("Action", "DescribeLoadBalancerPolicyTypes");
        request.addParameter("Version", "2012-06-01");
        request.setHttpMethod(HttpMethodName.POST);
        SdkInternalList policyTypeNamesList = (SdkInternalList)describeLoadBalancerPolicyTypesRequest.policyTypeNames();
        if (!policyTypeNamesList.isEmpty() || !policyTypeNamesList.isAutoConstruct()) {
            int policyTypeNamesListIndex = 1;
            for (String policyTypeNamesListValue : policyTypeNamesList) {
                if (policyTypeNamesListValue != null) {
                    request.addParameter("PolicyTypeNames.member." + policyTypeNamesListIndex, StringUtils.fromString((String)policyTypeNamesListValue));
                }
                ++policyTypeNamesListIndex;
            }
        }
        return request;
    }
}

