/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticloadbalancing.transform;

import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.runtime.SdkInternalList;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.services.elasticloadbalancing.model.CreateLoadBalancerPolicyRequest;
import software.amazon.awssdk.services.elasticloadbalancing.model.PolicyAttribute;
import software.amazon.awssdk.util.StringUtils;

public class CreateLoadBalancerPolicyRequestMarshaller
implements Marshaller<Request<CreateLoadBalancerPolicyRequest>, CreateLoadBalancerPolicyRequest> {
    public Request<CreateLoadBalancerPolicyRequest> marshall(CreateLoadBalancerPolicyRequest createLoadBalancerPolicyRequest) {
        SdkInternalList policyAttributesList;
        if (createLoadBalancerPolicyRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)createLoadBalancerPolicyRequest, "ElasticLoadBalancingClient");
        request.addParameter("Action", "CreateLoadBalancerPolicy");
        request.addParameter("Version", "2012-06-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (createLoadBalancerPolicyRequest.loadBalancerName() != null) {
            request.addParameter("LoadBalancerName", StringUtils.fromString((String)createLoadBalancerPolicyRequest.loadBalancerName()));
        }
        if (createLoadBalancerPolicyRequest.policyName() != null) {
            request.addParameter("PolicyName", StringUtils.fromString((String)createLoadBalancerPolicyRequest.policyName()));
        }
        if (createLoadBalancerPolicyRequest.policyTypeName() != null) {
            request.addParameter("PolicyTypeName", StringUtils.fromString((String)createLoadBalancerPolicyRequest.policyTypeName()));
        }
        if (!(policyAttributesList = (SdkInternalList)createLoadBalancerPolicyRequest.policyAttributes()).isEmpty() || !policyAttributesList.isAutoConstruct()) {
            int policyAttributesListIndex = 1;
            for (PolicyAttribute policyAttributesListValue : policyAttributesList) {
                if (policyAttributesListValue.attributeName() != null) {
                    request.addParameter("PolicyAttributes.member." + policyAttributesListIndex + ".AttributeName", StringUtils.fromString((String)policyAttributesListValue.attributeName()));
                }
                if (policyAttributesListValue.attributeValue() != null) {
                    request.addParameter("PolicyAttributes.member." + policyAttributesListIndex + ".AttributeValue", StringUtils.fromString((String)policyAttributesListValue.attributeValue()));
                }
                ++policyAttributesListIndex;
            }
        }
        return request;
    }
}

