/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticloadbalancing.model;

import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.runtime.SdkInternalList;
import software.amazon.awssdk.services.elasticloadbalancing.model.SubnetsCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class AttachLoadBalancerToSubnetsRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, AttachLoadBalancerToSubnetsRequest> {
    private final String loadBalancerName;
    private final List<String> subnets;

    private AttachLoadBalancerToSubnetsRequest(BuilderImpl builder) {
        this.loadBalancerName = builder.loadBalancerName;
        this.subnets = builder.subnets;
    }

    public String loadBalancerName() {
        return this.loadBalancerName;
    }

    public List<String> subnets() {
        return this.subnets;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.loadBalancerName() == null ? 0 : this.loadBalancerName().hashCode());
        hashCode = 31 * hashCode + (this.subnets() == null ? 0 : this.subnets().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AttachLoadBalancerToSubnetsRequest)) {
            return false;
        }
        AttachLoadBalancerToSubnetsRequest other = (AttachLoadBalancerToSubnetsRequest)((Object)obj);
        if (other.loadBalancerName() == null ^ this.loadBalancerName() == null) {
            return false;
        }
        if (other.loadBalancerName() != null && !other.loadBalancerName().equals(this.loadBalancerName())) {
            return false;
        }
        if (other.subnets() == null ^ this.subnets() == null) {
            return false;
        }
        return other.subnets() == null || other.subnets().equals(this.subnets());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.loadBalancerName() != null) {
            sb.append("LoadBalancerName: ").append(this.loadBalancerName()).append(",");
        }
        if (this.subnets() != null) {
            sb.append("Subnets: ").append(this.subnets()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String loadBalancerName;
        private List<String> subnets = new SdkInternalList();

        private BuilderImpl() {
        }

        private BuilderImpl(AttachLoadBalancerToSubnetsRequest model) {
            this.setLoadBalancerName(model.loadBalancerName);
            this.setSubnets(model.subnets);
        }

        public final String getLoadBalancerName() {
            return this.loadBalancerName;
        }

        @Override
        public final Builder loadBalancerName(String loadBalancerName) {
            this.loadBalancerName = loadBalancerName;
            return this;
        }

        public final void setLoadBalancerName(String loadBalancerName) {
            this.loadBalancerName = loadBalancerName;
        }

        public final Collection<String> getSubnets() {
            return this.subnets;
        }

        @Override
        public final Builder subnets(Collection<String> subnets) {
            this.subnets = SubnetsCopier.copy(subnets);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder subnets(String ... subnets) {
            if (this.subnets == null) {
                this.subnets = new SdkInternalList(subnets.length);
            }
            for (String e : subnets) {
                this.subnets.add(e);
            }
            return this;
        }

        public final void setSubnets(Collection<String> subnets) {
            this.subnets = SubnetsCopier.copy(subnets);
        }

        @SafeVarargs
        public final void setSubnets(String ... subnets) {
            if (this.subnets == null) {
                this.subnets = new SdkInternalList(subnets.length);
            }
            for (String e : subnets) {
                this.subnets.add(e);
            }
        }

        public AttachLoadBalancerToSubnetsRequest build() {
            return new AttachLoadBalancerToSubnetsRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, AttachLoadBalancerToSubnetsRequest> {
        public Builder loadBalancerName(String var1);

        public Builder subnets(Collection<String> var1);

        public Builder subnets(String ... var1);
    }
}

