/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticbeanstalk.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.elasticbeanstalk.model.ActionType;
import software.amazon.awssdk.services.elasticbeanstalk.model.ElasticBeanstalkResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ApplyEnvironmentManagedActionResponse
extends ElasticBeanstalkResponse
implements ToCopyableBuilder<Builder, ApplyEnvironmentManagedActionResponse> {
    private static final SdkField<String> ACTION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ApplyEnvironmentManagedActionResponse.getter(ApplyEnvironmentManagedActionResponse::actionId)).setter(ApplyEnvironmentManagedActionResponse.setter(Builder::actionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ActionId").build()}).build();
    private static final SdkField<String> ACTION_DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ApplyEnvironmentManagedActionResponse.getter(ApplyEnvironmentManagedActionResponse::actionDescription)).setter(ApplyEnvironmentManagedActionResponse.setter(Builder::actionDescription)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ActionDescription").build()}).build();
    private static final SdkField<String> ACTION_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ApplyEnvironmentManagedActionResponse.getter(ApplyEnvironmentManagedActionResponse::actionTypeAsString)).setter(ApplyEnvironmentManagedActionResponse.setter(Builder::actionType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ActionType").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ApplyEnvironmentManagedActionResponse.getter(ApplyEnvironmentManagedActionResponse::status)).setter(ApplyEnvironmentManagedActionResponse.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACTION_ID_FIELD, ACTION_DESCRIPTION_FIELD, ACTION_TYPE_FIELD, STATUS_FIELD));
    private final String actionId;
    private final String actionDescription;
    private final String actionType;
    private final String status;

    private ApplyEnvironmentManagedActionResponse(BuilderImpl builder) {
        super(builder);
        this.actionId = builder.actionId;
        this.actionDescription = builder.actionDescription;
        this.actionType = builder.actionType;
        this.status = builder.status;
    }

    public String actionId() {
        return this.actionId;
    }

    public String actionDescription() {
        return this.actionDescription;
    }

    public ActionType actionType() {
        return ActionType.fromValue(this.actionType);
    }

    public String actionTypeAsString() {
        return this.actionType;
    }

    public String status() {
        return this.status;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.actionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.actionDescription());
        hashCode = 31 * hashCode + Objects.hashCode(this.actionTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.status());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ApplyEnvironmentManagedActionResponse)) {
            return false;
        }
        ApplyEnvironmentManagedActionResponse other = (ApplyEnvironmentManagedActionResponse)((Object)obj);
        return Objects.equals(this.actionId(), other.actionId()) && Objects.equals(this.actionDescription(), other.actionDescription()) && Objects.equals(this.actionTypeAsString(), other.actionTypeAsString()) && Objects.equals(this.status(), other.status());
    }

    public String toString() {
        return ToString.builder((String)"ApplyEnvironmentManagedActionResponse").add("ActionId", (Object)this.actionId()).add("ActionDescription", (Object)this.actionDescription()).add("ActionType", (Object)this.actionTypeAsString()).add("Status", (Object)this.status()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ActionId": {
                return Optional.ofNullable(clazz.cast(this.actionId()));
            }
            case "ActionDescription": {
                return Optional.ofNullable(clazz.cast(this.actionDescription()));
            }
            case "ActionType": {
                return Optional.ofNullable(clazz.cast(this.actionTypeAsString()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.status()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ApplyEnvironmentManagedActionResponse, T> g) {
        return obj -> g.apply((ApplyEnvironmentManagedActionResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ElasticBeanstalkResponse.BuilderImpl
    implements Builder {
        private String actionId;
        private String actionDescription;
        private String actionType;
        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(ApplyEnvironmentManagedActionResponse model) {
            super(model);
            this.actionId(model.actionId);
            this.actionDescription(model.actionDescription);
            this.actionType(model.actionType);
            this.status(model.status);
        }

        public final String getActionId() {
            return this.actionId;
        }

        @Override
        public final Builder actionId(String actionId) {
            this.actionId = actionId;
            return this;
        }

        public final void setActionId(String actionId) {
            this.actionId = actionId;
        }

        public final String getActionDescription() {
            return this.actionDescription;
        }

        @Override
        public final Builder actionDescription(String actionDescription) {
            this.actionDescription = actionDescription;
            return this;
        }

        public final void setActionDescription(String actionDescription) {
            this.actionDescription = actionDescription;
        }

        public final String getActionTypeAsString() {
            return this.actionType;
        }

        @Override
        public final Builder actionType(String actionType) {
            this.actionType = actionType;
            return this;
        }

        @Override
        public final Builder actionType(ActionType actionType) {
            this.actionType(actionType == null ? null : actionType.toString());
            return this;
        }

        public final void setActionType(String actionType) {
            this.actionType = actionType;
        }

        public final String getStatus() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public ApplyEnvironmentManagedActionResponse build() {
            return new ApplyEnvironmentManagedActionResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ElasticBeanstalkResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ApplyEnvironmentManagedActionResponse> {
        public Builder actionId(String var1);

        public Builder actionDescription(String var1);

        public Builder actionType(String var1);

        public Builder actionType(ActionType var1);

        public Builder status(String var1);
    }
}

